//
//  GSAnchor.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.8.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import "GSElement.h"
#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(uint8_t, GSAnchorType) {
	BaseAnchor = 0,
	MarkAnchor = 1
};

/// The class defining the anchor object

@interface GSAnchor : GSElement <NSCoding, NSCopying> {

	NSString *_name;
	GSAnchorType _type;
	BOOL _selected;
}

/// Name of the anchor.
@property (copy, nonatomic) NSString *name;

- (void)setNameFast:(NSString *)name;

@property (nonatomic) GSAnchorType type;

@end
NS_ASSUME_NONNULL_END
