//
//  GSFilterPlugin.h
//  GlyphsCore
//
//  Created by Georg Seifert on 19.01.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import "GSDialogController.h"
#import "GSGlyphViewControllerProtocol.h"
#import "GlyphsFilterProtocol.h"
#import <Cocoa/Cocoa.h>
@class GSFontMaster;

@interface GSFilterPlugin : NSObject <GlyphsFilter, GSDialogDelegateProtocol> {
	//! will be set by Glyphs
	__unsafe_unretained NSViewController<GSGlyphEditViewControllerProtocol> *controller;
	//! will be set by Glyphs
	BOOL rerun;
	//! set this up in Interface Builder or generate programatically
	IBOutlet NSView *_view;

	//! if the plugin run is called through runFilterWithLayer: you might mant to pay attention to the current selection state.
	BOOL _checkSelection;
	//! for your internal use.
	BOOL returnValue;

	GSFontMaster *__unsafe_unretained _fontMaster;
	NSMutableArray *_layers;
	NSMutableArray *_shadowLayers;
	IBOutlet NSControl *myFirstResponder;
	GSDialogController *_dialog;
}

- (void)cancelDialog:(id)sender;

- (void)process:(id)sender;

- (NSError *)setup;

- (void)final;
//- (BOOL) runFilterWithLayer:(GSLayer*) Layer error: (NSError **) error ;
//- (BOOL) runFilterWithLayers:(NSArray*) Layers error: (NSError **) error ;
@end
