//
//  GSSVGPen.h
//  GlyphsCore
//
//  Created by Georg Seifert on 07/11/2016.
//  Copyright © 2016 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSBasePen.h>

@interface GSSVGPen : GSBasePen {
	CGFloat _height;
	NSXMLDocument *_svgDoc;
	NSXMLElement *_currentElement;
	NSMutableString *_currentPath;
	char _lastCommand;
	NSColor *_fillColor;
	NSColor *_strokeColor;
	CGFloat _lineWidth;
	CGFloat _radius;
	CGFloat _blur;
	NSColor *_shadowColor;
	NSRect _bounds;
	NSAffineTransform *_transform;
}

@property (nonatomic, readonly) NSXMLDocument *svgDoc;

@property (nonatomic, strong) NSColor *fillColor;
@property (nonatomic, strong) NSString *fillColorString;
@property (nonatomic, strong) NSColor *strokeColor;
@property (nonatomic) CGFloat lineWidth;

@property (nonatomic, strong) NSAffineTransform *transform;
- (void)setShadow:(CGFloat)radius blur:(CGFloat)blur color:(NSColor *)color;

@end
