//
//  GSSubstitution.h
//  Glyphs
//
//  Created by Georg Seifert on 9.9.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum : uint8_t {
	GSSubstitutionSingle,
	GSSubstitutionLigature,
	GSSubstitutionContext,
} GSSubstitutionType;

@interface GSSubstitution : NSObject <NSCoding, NSCopying> {
	NSString *_back;
	NSString *_source;
	NSString *_fwd;
	NSString *_target;
	BOOL _ignore;
	NSArray *_languageTags;
	NSString *_scriptTag;
	NSString *_lookupFlag;
}
//! Context glyphs (as glyph names) before the source.
/*
 As glyph names.
 */
@property (strong, nonatomic) NSString *back;
//! The source  glyphs.
/*
 As glyph names.
 */

@property (strong, nonatomic) NSString *source;
//! Context glyphs after the source.
/*
 As glyph names.
 */

@property (strong, nonatomic) NSString *fwd;
//! The target glyphs.
/*
 As glyph names.
 */
@property (strong, nonatomic) NSString *target;

/// this is a ignore-substitution
@property (nonatomic) BOOL ignore;
/// the language tags
@property (strong, nonatomic) NSArray *languageTags;
/// the script tag
@property (strong, nonatomic) NSString *scriptTag;
/// the lookupFlag
@property (strong, nonatomic) NSString *lookupFlag;

@property (nonatomic, readonly) GSSubstitutionType type;

//! Init with dictionary loaded from pList.
- (instancetype)initWithDict:(NSDictionary *)Dict;

//! Init with String in OT syntax.
- (instancetype)initWithCode:(NSString *)Code;

//! Returns a dictionary to store in pList.
//- (GSSubstitution*) substitutionForFont:(GSFont*) Font source:(NSString*) Source target:(NSString*) Target ;
- (NSDictionary *)substDict;

/// The substitution representation in FDK syntax.
- (NSString *)code;
@end
