//
//  GSToolPlugin.h
//  GlyphsCore
//
//  Created by Georg Seifert on 27.01.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import "GSGlyphViewControllerProtocol.h"
#import "GSWindowControllerProtocol.h"
#import "GlyphsToolEventProtocol.h"
#import <Cocoa/Cocoa.h>

@class GSLayer;
@class GSElement;

@class GSInspectorViewController;

@interface GSToolPlugin : NSResponder <GlyphsTool> {
	__weak NSWindowController<GSWindowControllerProtocol> *_windowController;
	__weak NSViewController<GSGlyphEditViewControllerProtocol> *_editViewController;
	NSMutableDictionary<NSString *, GSInspectorViewController *> *_inspectorViewControllers;
}

- (GSElement *)elementAtPoint:(NSPoint)Loc atLayer:(GSLayer *)Layer;

@end
