//
//  GSToolSelect.h
//  GlyphsCore
//
//  Created by Georg Seifert on 16.04.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GlyphsPathPlugin.h>

@class GSElement;
@class GSHandle;
@class GSPartsPropertiesViewController;

@interface GSToolSelect : GlyphsPathPlugin {
	NSRect _auswahlRect;
	NSCursor *elementCursor;
	CGFloat grabbedPathTime;
	NSPoint _draggElementOffset;
	GSHandle *_referenceHandle;
	BOOL _drawHangulComponentCloud;
}
//@property (nonatomic, retain) GSHandle *selectionBoundsHandle;

@property (nonatomic, retain) GSPartsPropertiesViewController *partsProperties;

- (void)mouseDoubleDown:(NSEvent *)theEvent;

- (void)selectGlyph:(NSEvent *)theEvent;

- (void)selectAtPoint:(NSPoint)Point withModifier:(NSUInteger)modifierFlag;

- (void)selectInRect:(NSRect)Rect withModifier:(NSUInteger)modifierFlag;

- (GSElement *)elementAtPoint:(NSPoint)Loc atLayer:(GSLayer *)Layer;

- (GSElement *)elementAtPoint:(NSPoint)aPoint atLayer:(GSLayer *)Layer ignoreLocked:(BOOL)ignoreLocked;

- (NSMutableArray *)elementsInRect:(NSRect)aRect atLayer:(GSLayer *)layer modifier:(NSUInteger)modifierFlag;
//- (void) selectNext ;
- (void)insertTab:(id)sender;

- (void)insertBacktab:(id)sender;

- (IBAction)reconnectNodes:(id)sender;

- (IBAction)openCorners:(id)sender;

- (IBAction)decomposeComponentsSelection:(id)sender;

- (IBAction)makeGlobal:(id)sender;

- (IBAction)setBackgroundImageCropToMetrics:(id)sender;

- (GSHandle *)handleForPoint:(NSPoint)aPoint atBounds:(NSRect)Bounds angle:(NSAffineTransform *)transform;
@end
