//
//  GlyphsPaletteProtocol.h
//  PalettePlugin
//
//  Created by Georg Seifert on 4.7.07.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol GSWindowControllerProtocol;

/*! \brief GlyphsPalette: The protocol defining the palette plugin interface
 \ingroup common
 The protocol defining the palette plugin interface.
 */
@protocol GlyphsPalette

/**
 The window controller managin the window the panel is in
 */
@property (nonatomic, weak) NSWindowController<GSWindowControllerProtocol> *windowController;
//! The interface version.
@property (readonly, nonatomic) NSUInteger interfaceVersion;
//! The title of the plugin.
@property (readonly, nonatomic) NSString *title;
//! the view to display in the palette.
@property (readonly, strong, nonatomic) NSView *theView;
//! the minimal height of the view.
@property (readonly, nonatomic) NSInteger minHeight;
//! the maximal height of the view.
@property (readonly, nonatomic) NSInteger maxHeight;
@optional

/** The current height of the palette
 
 Implement this when your palette is resizeable
 */
@property (assign, nonatomic) NSUInteger currentHeight;

@optional

//! do main initialisations
- (void)loadPlugin;

/** The group ID defines the position of the tool in the sidebar.
 
 - Dimensions: 10
 - FitCurve: 20
 - Layers: 30
 - Transform: 40
 */
@property (readonly, nonatomic) NSUInteger sortID;
@end
