/// /// /// ////// ////// ////// ////// ////// ////// ////// ////// ////// ////// ////// ///
//
//	SEQOY™ Development and Consulting
//	http://www.seqoy.com
//
///////////////
//
//	History:
//
//	19/12/08 --- Created by Matt Gallagher (http://cocoawithlove.com/)
//	20/09/09 --- Several changes by Paulo Oliveira
//
//	MGOrderedDictionary.h
//
/// /// /// ////// ////// ////// ////// ////// ////// ////// ////// ////// ////// ////// ///
//
//  Permission is given to use this source code file without charge in any
//  project, commercial or otherwise, entirely at your risk, with the condition
//  that any redistribution (in part or whole) of source code must retain
//  this copyright and permission notice. Attribution in compiled projects is
//  appreciated but not required.
//
/// /// /// ////// ////// ////// ////// ////// ////// //
#import <Foundation/Foundation.h>

@interface MGOrderedDictionary <KeyType, ObjectType> : NSMutableDictionary {
	NSMutableDictionary *dictionary;
	NSMutableArray *array;
}

//// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// ////
#pragma mark -

#pragma mark Init Methods.

- (instancetype)initWithCapacity:(NSUInteger)capacity;

- (instancetype)initWithDictionary:(NSDictionary *)anObject;

- (instancetype)initWithObject:(NSMutableDictionary *)anObject withArray:(NSMutableArray *)anArray;

/// This method is similar to initWithDictionary, the difference is: This method will Scan the all Dictionary tree converting internal elements too.

- (instancetype)initConvertFromDictionary:(id)anObject;

#pragma mark -
#pragma mark Sorting Methods.

/// Reorder the Dictionary using one giving function.
- (void)sortUsingFunction:(NSInteger (*)(id, id, void *))comparator context:(void *)context;

- (void)sortUsingSelector:(SEL)Comparator;

- (void)sortUsingDescriptors:(NSArray *)sortDescriptors;

- (void)sortUsingComparator:(NSComparator)cmptr;

#pragma mark -
#pragma mark Insert Methods.
- (id)objectForKeyedSubscript:(id)aKey;

- (void)setObject:(id)anObject forKey:(id)aKey;

- (void)setObject:(id)anObject forKeyedSubscript:(id)aKey;

- (void)insertObject:(id)anObject forKey:(id)aKey atIndex:(NSUInteger)anIndex;

- (void)addEntriesFromDictionary:(NSDictionary *)otherDictionary;

#pragma mark -
#pragma mark Remove Methods.

- (void)removeLastObject;

- (void)removeAllObjects;

- (void)removeObjectForKey:(id)aKey;

- (void)removeObjectAtIndex:(NSUInteger)anIndex;

- (BOOL)removeObjectFromIndex:(NSUInteger)from To:(NSUInteger)to; // This method could be slow on large dictionaries.

- (void)removeObjectsInRange:(NSRange)aRange; // This method could be slow on large dictionaries.

- (void)removeObjectsForKeys:(NSArray *)keyArray;
//// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// ////
#pragma mark -
//// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// //// ////
#pragma mark Retrieve Methods.

- (id)objectAtIndex:(NSUInteger)anIndex;

- (id)objectAtIndexedSubscript:(NSUInteger)idx NS_AVAILABLE(10_8, 6_0);

- (NSUInteger)indexOfKey:(id)aKey;

- (id)keyAtIndex:(NSUInteger)anIndex;

#pragma mark Manipulate Methods.

- (void)swipeIndex:(NSUInteger)from with:(NSUInteger)to;

- (void)exchangeObjectAtIndex:(NSUInteger)idx1 withObjectAtIndex:(NSUInteger)idx2; // This is the same of swipeIndex, this method is just for compatibility.

- (void)moveFromIndex:(NSUInteger)from To:(NSUInteger)to;

- (NSEnumerator *)reverseKeyEnumerator;

@end
