//
//  GSFontMaster.h
//  Glyphs
//
//  Created by Georg Seifert on 6.9.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSContainerProtocol.h>
#import <GlyphsCore/GSUserDataProtocol.h>

@class GSFont;
@class GSGlyph;
@class GSLayer;
#ifndef GLYPHS_VIEWER
@class GSGuideLine;
@class GSCustomParameter;
#endif
@class GSAlignmentZone;
@class GSIndexedLookupTable;

/** The class defining the fontmaster object */
#ifndef GLYPHS_VIEWER
@interface GSFontMaster : NSObject <NSCoding, NSCopying, GSContainerProtocol, GSUserDataProtocol>
#else
@interface GSFontMaster : NSObject
#endif
{
	//NSInteger _index;
	GSFont *__unsafe_unretained _font;
	CGFloat _xHeight;
	CGFloat _descender;
	CGFloat _ascender;
	CGFloat _capHeight;
	CGFloat _italicAngle;
	NSMutableArray<GSAlignmentZone *> *_alignmentZones;
#ifndef GLYPHS_VIEWER
	NSMutableDictionary *_userData;
#endif
#ifdef LIBCORE
	NSString *_weight;
	NSString *_width;
	NSString *_custom;
#endif
	NSString *_id;
	CGFloat _weightValue, _widthValue, _customValue, _customValue1, _customValue2, _customValue3;
#ifndef GLYPHS_VIEWER
	NSMutableArray *_guideLines;
#endif
	NSMutableDictionary *_changeCount;
	NSMutableIndexSet *_alignmentZoneCache;
	GSIndexedLookupTable *_alignmentZoneLookup;
	NSMutableArray *_customParameters;
	NSMutableArray *_metricsList;
	NSString *_name;
	NSString *_iconName;
	NSUInteger _gridMain;
	NSUInteger _gridSubDivision;
}
@property (unsafe_unretained, nonatomic) GSFont *font;
/** @name Properties */

/** the name of the FontMaster
e.g; "Regular", "Condensed", ...
*/
@property (nonatomic, strong) NSString *name;

@property (nonatomic, strong) NSString *iconName;

- (NSImage *)icon;

@property (nonatomic, readonly) NSString *nameUI;

#ifdef LIBCORE

/** The width tag

Something like Condensed or Extended
*/
@property (copy, nonatomic) NSString *width;

/** The weight tag

Something like Light or Regular
*/
@property (copy, nonatomic) NSString *weight;

/** A custom tag */
@property (copy, nonatomic) NSString *custom;
#endif

/** The weight value

The weight value defines the place of the Fontmaster in the "design space"
*/
@property (assign, nonatomic) CGFloat weightValue;

/** The width value

The width value defines the place of the Fontmaster in the "design space"
*/
@property (assign, nonatomic) CGFloat widthValue;

/** The custom value

The custom value defines the place of the Fontmaster in the "design space"
*/
@property (assign, nonatomic) CGFloat customValue;
@property (assign, nonatomic) CGFloat customValue1;
@property (assign, nonatomic) CGFloat customValue2;
@property (assign, nonatomic) CGFloat customValue3;

/// The id
@property (copy, nonatomic) NSString *id;

@property (nonatomic) BOOL visible;
/// The descender.
@property (nonatomic) CGFloat descender;

- (CGFloat)descenderForLayer:(GSLayer *)layer;

/// The ascender.
@property (nonatomic) CGFloat ascender;

- (CGFloat)ascenderForLayer:(GSLayer *)layer;

/// The capHeight.
@property (nonatomic) CGFloat capHeight;

- (CGFloat)capHeightForLayer:(GSLayer *)layer;
/// The xHeight.
@property (nonatomic) CGFloat xHeight;

- (CGFloat)xHeightForLayer:(GSLayer *)layer;

/// The Italic angle
@property (nonatomic) CGFloat italicAngle;

- (CGFloat)italicAngleForLayer:(GSLayer *)layer;

- (CGFloat)slantHeightForLayer:(GSLayer *)layer;
	
/// list of vertical stems
@property (strong, nonatomic) NSArray<NSNumber *> *verticalStems;

- (void)addObjectInVerticalStems:(NSNumber *)stem;

/// list of horizontal stems
@property (strong, nonatomic) NSArray<NSNumber *> *horizontalStems;

- (void)addObjectInHorizontalStems:(NSNumber *)stem;

/// list of alignment zones
@property (strong, nonatomic) NSArray *alignmentZones;
/// list of guidelines
@property (strong, nonatomic) NSArray *guideLines;


@property (strong, nonatomic) NSMutableArray *customParameters;

/** @name Initializing an Font Master */

/// Inits with a Dict loaded from pList.
- (instancetype)initWithFontMasterDict:(NSDictionary *)FontMasterDict;

#ifndef GLYPHS_VIEWER

/// Returns the Font Master to save it in plist
- (NSDictionary *)fontMasterDict;

- (BOOL)saveToFile:(FILE *)File error:(NSError *__autoreleasing *)error;

/** @name Guides */

/** Number of Guide Lines

@return Number of Guide Lines
*/
- (NSUInteger)guideLineCount;

/** Returns the Guide Line located at Index.
@param theIndex An index within the bounds of the array.
@return The Guide Line located at index.
*/
- (id)guideLineAtIndex:(NSUInteger)theIndex;

//- (void) getGuideLines:(id*)objsPtr range:(NSRange)range ;
- (void)addGuideLine:(GSGuideLine *)GuideLine;

- (void)removeGuideLine:(GSGuideLine *)GuideLine;

- (void)insertGuideLine:(GSGuideLine *)GuideLine atIndex:(NSUInteger)theIndex;

- (void)removeGuideLineAtIndex:(NSUInteger)theIndex;

#endif
/** @name Alignment Zones */
/** Number of alignment zones

@return Number of alignment zones
*/
- (NSUInteger)countOfAlignmentZones;

/** Returns the alignment zone located at Index.
@param Index An index within the bounds of the array.
@return The object located at index.
*/
- (GSAlignmentZone *)alignmentZoneAtIndex:(NSUInteger)Index;
/** adds an alignment zone
@param AlignmentZone a GSAlignmentZone object
*/
#ifndef GLYPHS_VIEWER

- (void)addAlignmentZone:(GSAlignmentZone *)AlignmentZone;

- (void)addAlignmentZones:(NSArray *)AlignmentZones;

- (void)removeAlignmentZone:(GSAlignmentZone *)AlignmentZone;

- (void)removeAlignmentZones:(NSArray *)AlignmentZones;

- (void)removeAlignmentZoneAtIndex:(NSUInteger)theIndex;

- (void)removeAlignmentZoneAtIndexes:(NSIndexSet *)theIndexes;

- (void)sortAlignmentZones;

- (NSArray *)blueValues;

- (NSArray *)otherBlues;

#endif

- (NSArray *)alignmentZonesForLayer:(GSLayer *)layer;

- (BOOL)isInAlignmentZone:(NSInteger)Height layer:(GSLayer *)Layer;

- (GSAlignmentZone *)alignmentZoneAtPosition:(NSInteger)position;

- (BOOL)isOnMetricsLine:(NSPoint)position layer:(GSLayer *)Layer;

@property (nonatomic, assign) NSUInteger gridMain;

@property (nonatomic, assign) NSUInteger gridSubDivision;
#ifndef GLYPHS_VIEWER

///////  customParameters  ///////
- (NSArray *)customParameters;

- (NSUInteger)countOfCustomParameters;

- (GSCustomParameter *)objectInCustomParametersAtIndex:(NSUInteger)theIndex;

- (GSCustomParameter *)customParameterForKey:(NSString *)Key;

- (void)addCustomParameter:(GSCustomParameter *)Property;

#endif


- (id)customValueForKey:(NSString *)key;

- (BOOL)customBoolValueForKey:(NSString *)key;

- (id)customColorValueForKey:(NSString *)key;

#ifndef GLYPHS_VIEWER

- (void)setCustomParameter:(id)value forKey:(NSString *)key;

- (void)removeObjectFromCustomParametersForKey:(NSString *)Key;

- (void)insertObject:(GSCustomParameter *)aCustomProperty inCustomParametersAtIndex:(NSUInteger)idx;

- (void)removeObjectFromCustomParametersAtIndex:(NSUInteger)idx;

- (void)replaceObjectInCustomParametersAtIndex:(NSUInteger)idx withObject:(GSCustomParameter *)aCustomProperty;

+ (CGFloat)localizedParameter:(NSString *)parameter glyph:(GSGlyph *)glyph;

- (CGFloat)localizedCustomValueForKey:(NSString *)key layer:(GSLayer *)layer;

- (CGFloat)localizedCustomValueForKey:(NSString *)key script:(NSString *)script;

/** @name Other Methods */
/** Scales the Font Master
Scales the vertical metrics, alignment zones and guide lines
@param Scale the scale factor (1 means no scaling.)
*/
- (void)scaleBy:(CGFloat)Scale;

- (void)fixAlignmentZone;
#endif

+ (NSArray *)iconName;

@end
