//
//  GSHint.h
//  GlyphsCore
//
//  Created by Georg Seifert on 21.01.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import "GSElement.h"
#import <Cocoa/Cocoa.h>

@class GSNode;
/**
 Hint types
 */

typedef NS_ENUM(int8_t, GSHintType) {
	/** Tag */
	Tag = -2,
	/** TopGhost for PS hints */
	TopGhost = -1,
	/** Stem for PS hints */
	Stem = 0,
	/** BottomGhost for PS hints */
	BottomGhost = 1,
	/** Flex */
	Flex = 2,
	/** Anchor for TT hints */
	TTAnchor = 3,
	/** Stem for TT hints */
	TTStem = 4,
	/** Aling for TT hints */
	TTAlign = 5,
	/** Interpolation for TT hints */
	TTInterpolate = 6,
	/** Interplate Stem */
	TTInterpolateStem = 7,
	/** Diagonal for TT hints */
	TTDiagonal = 8,
	/** Delta hints */
	TTDelta = 9,
	/** Corner Component */
	Corner = 16,
	/** Cap Component */
	Cap = 17,
	/** Auto */
	Auto = 0x7f,
};

typedef NS_ENUM(NSInteger, GSSpecialHintFlags) {
	GSIntersectionFlag = 1000,
	GSLSBFlag = 1001,
	GSRSBFlag = 1002,
	GSInflectionFlag = 1003,
};

/** Hint Options */
typedef NS_ENUM(uint8_t, GSHintOptions) {
	TTDontRound = 4,
	TTRound = 0,
	TTRoundUp = 1,
	TTRoundDown = 2,
	TTRoundAuto = 8,
	Trippel = 128,
};

#ifndef hintOriginLSBIndex
#define hintOriginLSBIndex 0x1fffe
#define hintOriginRSBIndex 0x1ffff
#endif

@interface GSHint : GSElement <NSCoding, NSCopying> {

	GSNode *_originNode;
	GSNode *_targetNode;
	GSNode *_otherNode1;
	GSNode *_otherNode2;
	NSIndexPath *_originIndex;
	NSIndexPath *_targetIndex;
	NSIndexPath *_otherIndex1;
	NSIndexPath *_otherIndex2;

	GSHintType _type;
	NSRect _badgeRect;
	NSPoint _originKnob;
	NSPoint _targetKnob;
	NSPoint _otherKnob1;
	NSPoint _otherKnob2;
	int _selection;
	NSInteger _stem;
	NSString *_name;
	uint32_t _options;
	NSDate *_lastUpdate;
	NSMutableDictionary *_settings;
	NSMutableDictionary *_tempData;
  @public
	NSUInteger _ttOriginIndex;
	NSUInteger _ttTargetIndex;
	NSUInteger _ttOtherIndex1;
	NSUInteger _ttOtherIndex2;
	CGFloat _origin;
	CGFloat _width;
	NSPoint _scale;
	BOOL _horizontal;
	CGFloat _rotate;
}

@property (nonatomic) CGFloat origin;
@property (nonatomic) CGFloat width;
@property (nonatomic) BOOL horizontal;
@property (strong, nonatomic, nullable) GSNode *originNode;
@property (strong, nonatomic, nullable) GSNode *targetNode;
@property (strong, nonatomic, nullable) GSNode *otherNode1;
@property (strong, nonatomic, nullable) GSNode *otherNode2;
@property (strong, nonatomic, nullable) NSIndexPath *originIndex;
@property (strong, nonatomic, nullable) NSIndexPath *targetIndex;
@property (strong, nonatomic, nullable) NSIndexPath *otherIndex1;
@property (strong, nonatomic, nullable) NSIndexPath *otherIndex2;
@property (nonatomic) GSHintType type;
@property (nonatomic) NSRect badgeRect;
@property (nonatomic) NSPoint originKnob;
@property (nonatomic) NSPoint targetKnob;
@property (nonatomic) NSPoint otherKnob1;
@property (nonatomic) NSPoint otherKnob2;

@property (nonatomic) int selection;
@property (nonatomic) NSInteger stem;
@property (nonatomic, strong, nullable) NSString *name;
@property (nonatomic) uint32_t options;
@property (nonatomic) NSTextAlignment alignment;
@property (nonatomic) NSPoint scale;
@property (nonatomic, strong, nullable) NSDate *lastUpdate;
@property (nonatomic, strong, nullable) NSMutableDictionary *tempData;

- (instancetype _Nullable)initWithHintDict:(NSDictionary *_Nonnull)HintDict;

- (void)makeGhost;

- (void)prepare;

- (void)save;

- (void)restore;

- (BOOL)updateIndexes;

- (NSSet *_Nullable)dependenIndexes;

- (NSSet *_Nullable)touchingIndexes;

- (NSSet *_Nullable)touchingIndexesAlreadyTouched:(NSSet *_Nonnull)AlreadyTouchedIndexes;

- (BOOL)isTrueType;

- (BOOL)isPostScript;

- (BOOL)isCorner;

@property (nonatomic, strong, nullable) NSDictionary *settings;

- (id _Nullable)objectInSettingsForKey:(NSString *_Nonnull)key;

- (void)setObjectInSettings:(id _Nullable)value forKey:(NSString *_Nonnull)key;

- (void)setObjectInTempData:(id _Nullable )object forKey:(NSString *_Nonnull)key;

+ (NSIndexPath *_Nullable)indexPathForNode:(GSNode *_Nonnull)Node inLayer:(GSLayer *_Nonnull)Layer;

+ (nullable NSIndexPath *)indexPathForPosition:(NSPoint)aPoint inLayer:(nullable GSLayer *)layer tolerance:(CGFloat)tolerance actualPosition:(NSPoint * _Nullable)actualPosition;

+ (NSIndexPath *_Nullable)indexPathsForInflection:(NSPoint)aPoint inLayer:(GSLayer *_Nonnull)Layer tollerance:(CGFloat)tollerance actuallPosition:(NSPoint *_Nullable)actuallPosition;

- (void)adjustToFlippedPath:(BOOL)reversed;
@end
