//
//  GSLayer+MetricsKeysUI.h
//  GlyphsCore
//
//  Created by Georg Seifert on 31.08.15.
//  Copyright (c) 2015 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSLayer.h>


typedef NS_ENUM(NSUInteger, GSMetricsKeysUI) {
	GSMetricsKeysOutOfSync = 0,
	GSMetricsKeysInSync = 1,
	GSMetricsKeysInvalid
};

@interface GSLayer (MetricsKeysUI)

- (NSInteger)alignedMetricsValueForKey:(NSString *)key;

@property (nonatomic, unsafe_unretained, nullable) NSString *leftMetricsKeyUI;
- (GSMetricsKeysUI)leftMetricsKeyIsInSync;
- (nonnull NSString *)leftMetricsKeyIsInSync:(GSMetricsKeysUI *__nullable)IsInSync;
- (NSString *__nullable)leftPlainMetricsKey;
- (NSColor *__nonnull)leftMetricsKeyColor;

@property (nonatomic, unsafe_unretained, nullable) NSString *widthMetricsKeyUI;

- (NSString *__nonnull)widthMetricsKeyUIFast;
- (GSMetricsKeysUI)widthMetricsKeyIsInSync;
- (NSString *__nonnull)widthMetricsKeyIsInSync:(GSMetricsKeysUI *__nullable)IsInSync;
- (NSString *)widthPlainMetricsKey;
- (NSColor *__nonnull)widthMetricsKeyColor;

@property (nonatomic, unsafe_unretained, nullable) NSString *rightMetricsKeyUI;
- (GSMetricsKeysUI)rightMetricsKeyIsInSync;
- (NSString *__nonnull)rightMetricsKeyIsInSync:(GSMetricsKeysUI *__nullable)IsInSync;
- (NSString *__nullable)rightPlainMetricsKey;
- (NSColor *__nonnull)rightMetricsKeyColor;

@property (nonatomic, unsafe_unretained, nullable) NSString *topMetricsKeyUI;
//- (NSString*)topMetricsKeyIsInSync:(BOOL*)IsInSync;

@property (nonatomic, unsafe_unretained, nullable) NSString *vertWidthMetricsKeyUI;

@property (nonatomic, unsafe_unretained, nullable) NSString *bottomMetricsKeyUI;
//- (NSString*)bottomMetricsKeyIsInSync:(BOOL*)IsInSync;

- (NSString *)vertOriginUIisPlaceholder:(BOOL *)placholder;
- (void)setVertOriginUI:(NSString *)vertOriginUI;

- (NSString *)vertWidthMetricsKeyUIisPlaceholder:(BOOL *)placholder;
- (void)setVertWidthMetricsKeyUI:(NSString *)vertWidthMetricsKeyUI;

- (GSMetricsKeysUI)vertWidthMetricsKeyIsInSync;
- (NSString *__nonnull)vertWidthMetricsKeyIsInSync:(GSMetricsKeysUI *__nonnull)IsInSync;

@end
