/*! \file GSNode.h */
//
//  GSNode.h
//  GlyphsCore
//
//  Created by Georg Seifert on 05.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import "GSElement.h"
#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSUserDataProtocol.h>

NS_ASSUME_NONNULL_BEGIN

/**
An enumeration of node and connection types.
*/
typedef NS_ENUM(uint8_t, GSNodeType) {
	/// Move
	MOVE = 17,
	/// Line
	LINE = 1,
	/// Curve
	CURVE = 35,
	/// Offcurve
	OFFCURVE = 65,
	/// Quadratic curve
	QCURVE = 36,
	/// Sharp connection
	SHARP = 0,
	/// Smooth connection
	SMOOTH = 100,
	SPECIAL = 101
};

/** The class defining the node object

 It is a subclass of GSElement
 */
@interface GSNode : GSElement <NSCoding, NSCopying, GSUserDataProtocol> {
	NSMutableDictionary *_userData;
  @public
	GSNodeType _type;
	GSNodeType _connection;
}
/// node type
@property (assign, nonatomic) GSNodeType type;
@property (readonly) char typeTag;

/// connection type
@property (assign, nonatomic) GSNodeType connection;

- (void)setElementString:(NSString *)String;

- (CFStringRef)elementString __attribute__((cf_returns_retained));

- (instancetype)initWithElementString:(NSString *)ElementString;

- (instancetype)initWithPosition:(NSPoint)position type:(GSNodeType)type connection:(GSNodeType)connection;

/** toggles the connection type between SHARP and SMOOTH */
- (void)toggleConnection;

- (void)checkConnection;

/** Convenient method to make this the first node in the path.*/
- (void)makeNodeFirst;

- (void)roundToGrid:(CGFloat)Grid;

@end
NS_ASSUME_NONNULL_END
