//
//  GSReadFromCharstring.h
//  GlyphsCore
//
//  Created by Georg Seifert on 03.12.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NSString *copyReadString(const char *Line, NSInteger Length) __attribute((ns_returns_retained));

NSString *copyReadTextLine(const char *Line, size_t Length) __attribute((ns_returns_retained));
NSString *copyReadText(const char *Line, size_t Length, FILE *File, char EndChar) __attribute((ns_returns_retained));

NSInteger readInt(const char *Line, NSUInteger *Pos);

NSColor *readColor(const char *Line, NSUInteger *Pos);

CGFloat readFloat(const char *Line, NSUInteger *Pos);

NSString *copyReadKey(const char *Line, NSUInteger *Pos) __attribute((ns_returns_retained));

NSString *copyReadValue(const char *Line, NSUInteger *Pos, NSUInteger MaxLength) __attribute((ns_returns_retained));

// this is only used for reading glyph Names as returned by tx
NSString *copyReadValueLimit(const char *Line, NSUInteger *Pos, NSUInteger MaxLength, char limit) __attribute((ns_returns_retained));

NSMutableDictionary *copyReadDict(FILE *File) __attribute((ns_returns_retained));

NSMutableArray *copyReadArray(FILE *File) __attribute((ns_returns_retained));

NSDate *readDate(const char *Line, NSUInteger Length);

NSAffineTransformStruct readTransformation(const char *Line);
