//
//  GSWindowControllerProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 26.03.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GSLayer;
@protocol GlyphsTool;
@protocol GlyphsToolEvent;
@protocol GlyphsToolDraw;
@protocol GSGlyphEditViewControllerProtocol;

@protocol GSWindowControllerProtocol
/** The tool that is currently handling events
 */
@property (unsafe_unretained, nonatomic) NSResponder<GlyphsToolDraw> *toolDrawDelegate;
@property (unsafe_unretained, nonatomic) NSResponder<GlyphsTool, GlyphsToolEvent> *toolEventDelegate;
@property (readonly, nonatomic) NSResponder<GlyphsTool, GlyphsToolEvent> *toolEventDelegateSelected;
@property (readonly, nonatomic) NSResponder<GlyphsTool, GlyphsToolEvent> *toolTempSelection;
/// if the Shift key is currently pressed
@property (nonatomic) BOOL ShiftKey;
/// if the alt/option key is currently pressed
@property (nonatomic) BOOL AltKey;
/// if the Ctrl key is currently pressed
@property (nonatomic) BOOL CtrlKey;
/// if the Command key is currently pressed
@property (nonatomic) BOOL CommandKey;
/// if the Space key is currently pressed
@property (nonatomic) BOOL SpaceKey;

/** The index of the tool that was active before the current.

 @see selectedToolIndex
 */
@property (nonatomic) NSUInteger lastSelectToolIndex;

/** The index of the currently active tool
 @see lastSelectToolIndex
 */
@property (nonatomic) NSUInteger selectedToolIndex;
@property (unsafe_unretained, nonatomic) IBOutlet NSArrayController *glyphListController;

/** the currently active layer of the window
 
 This is only valid if one layer has direct focus. If more then one are selected, this retruns nil.
 
 @return the active layer.
 */
- (GSLayer *)activeLayer;

- (NSArray *)selectedLayers;

- (NSArray *)allLayers;

/** The active editView controller or nil if the font view is active
 
 @return the active editview controller
 */

- (NSViewController<GSGlyphEditViewControllerProtocol> *)activeEditViewController;

/** The index of the active master
 
 @return The index of the active master
 */
- (NSUInteger)masterIndex;

/** The activate a tool based on its class
 
 @param aClass the class of the tool that sould be acivated.
 */
- (void)setToolForClass:(Class)aClass;

#ifndef GLYPHS_LITE

/** Show the font info window
 
 @param TabIndex the index of the tab that should be activated
 */
- (void)showFontInfoWindowWithTabSelected:(NSUInteger)TabIndex;

- (NSViewController<GSGlyphEditViewControllerProtocol> *)addTabWithString:(NSString *)displayString;

- (void)addTabWithLayers:(NSArray *)layers;
#endif

@end
