//
//  GlyphsPathPlugin.h
//  GlyphsCore
//
//  Created by Georg Seifert on 26.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import "GSGlyphViewControllerProtocol.h"
#import "GSToolPlugin.h"
#import "GlyphsToolDrawProtocol.h"
#import "GlyphsToolEventProtocol.h"
#import <Cocoa/Cocoa.h>

@class GSPath;
@class GSLayer;
@class GSAnchor;
@class GSComponent;
@class GSSnaper;
@class GSGuideLine;
@class GSFontMaster;
@class GSColorLabelViewController;

#define GSSmartAnchorFlag 2001

#import "GSHint.h"

@class GSAlignmentZone;
/**
 A base class for all path editing tools. It handles drawing and basic path interaction
 
 Subclass it for custom tool plugins
 */

@interface GlyphsPathPlugin : GSToolPlugin <GlyphsToolDraw, GlyphsToolEvent, NSMenuDelegate, NSTextViewDelegate> {
	//BOOL hasDragged;
	BOOL _dragging;
	NSPoint _draggStart;
	NSPoint _draggCurrent;
	NSPoint _contextClickPosition;
	//NSPoint _lastDragPosition;
	NSUInteger dragModifierFlag;
	//GSLayer *shadowLayer;
	NSMutableArray *_snappers;
	NSMutableArray *_activeSnappers;
	NSImage *_toolBarIcon;
	//NSImage *_toolBarIconSelect;
	//NSTimer *delayAction;
	//NSRect auswahlRect;
	GSLayer *_activeLayer;
	GSLayer *_foregroundLayer;
	GSElement *_grabbedElement;
	NSRect _selectionBounds;
	NSAffineTransform *_selectionBoundsAngle;
	NSRect _shadowSelectionBounds;
	CGFloat _interfaceScale;
	BOOL _shouldAlias;
	GSColorLabelViewController *_colorButtonsViewController;
	BOOL _isCancel;
	GSElement *_activeElement;
	NSColor *_nodeSmoothColorDefault;
	NSColor *_nodeCornerColorDefault;
	NSColor *_nodeSmoothColor;
	NSColor *_nodeCornerColor;
	NSColor *_handleColor;
	NSColor *_zonesColor;
	NSColor *_metricsColor;
	NSTimer *_removeSnapperTimer;
	BOOL _drawDark;
	int _handleSize;
}
//! The icon displayed in the toolbar.
@property (nonatomic, readonly) NSImage *toolBarIcon;
/** Yes if in a dragging state */
@property (nonatomic) BOOL dragging;

/** Origin of the current dragging operation
 */
@property (nonatomic) NSPoint draggStart;

/** The scaling factor for interface elements.
 
 On Retina displays its 1.75, otherwise 1.0
 */
@property (nonatomic, readonly) CGFloat interfaceScale;

/** Is called when the return key is pressed.
 
 Overwrite for your own behavior.
 @warning Never call that yourself.
 @param sender Typically the object that invoked this method.
 */
- (void)insertNewline:(id)sender;

/** Draws the starting node of an open path
 
 @param node  the start or end node
 @param sel   If the node is selected or not
 @param Point The origin point of the current layer
 */
- (void)drawBegin:(GSNode *)node isSelected:(BOOL)sel atPoint:(NSPoint)Point;

- (void)drawHandlesForBounds:(NSRect)Bounds atPoint:(NSPoint)aPoint angle:(NSAffineTransform *)transform;

- (void)drawHandle:(NSPoint)Position isSelected:(BOOL)selected atPoint:(NSPoint)aPoint;
/**
 Draws a node
 
 @param Path     The path that contains the node
 @param Index    The index of the node
 @param selected If the node is selected or not
 @param Point    The origin point of the current layer
 */
- (void)drawHandle:(GSPath *)Path atIndex:(NSUInteger)Index isSelected:(BOOL)selected atPoint:(NSPoint)Point simple:(BOOL)simple;

/** The rect that for drawing the node
 
 @param pt       the node postion
 @param selected If the node is selected or not
 @param Point    The origin point of the current layer
 
 @return the rect
 */
- (NSRect)getHandleRect:(NSPoint)pt isSelected:(bool)selected atPoint:(NSPoint)Point;

- (NSRect)getHandleRect:(NSPoint)pt isSelected:(bool)selected size:(CGFloat)sizeScale atPoint:(NSPoint)aPoint;

- (void)drawAnchor:(GSAnchor *)Anchor atPoint:(NSPoint)Point active:(BOOL)Active;

- (void)drawGuideLine:(GSGuideLine *)GuideLine atPoint:(NSPoint)aPoint selected:(BOOL)selected global:(BOOL)Global;

- (void)drawHint:(GSHint *)Hint atPoint:(NSPoint)aPoint selected:(BOOL)selected;

- (void)drawAlignmentZones:(GSLayer *)Layer atPoint:(NSPoint)aPoint;

- (void)drawShadowAccents:(GSLayer *)Layer atPoint:(NSPoint)Point;

@property (nonatomic) NSPoint transformOrigin;

- (NSRect)rectForHandle:(GSAlignment)HandleIndex forBounds:(NSRect)Bounds angle:(NSAffineTransform *)transform;
#ifndef GLYPHS_VIEWER

- (NSPoint)snapAtPoint:(NSPoint)Point withModifier:(NSUInteger)modifierFlag;

- (void)addSnapper:(GSSnaper *)Snapper;

- (void)addSnapperWithPoint:(NSPoint)Point;

- (void)addActiveSnapper:(GSSnaper *)Snapper;

- (NSArray *)smartAnchorsForComponent:(GSComponent *)component;
//- (void) addHoverPoint:(NSPoint) newPoint ;
- (NSArray *)selectedObjects;

- (IBAction)selectAll:(id)sender;

- (IBAction)deselectAll:(id)sender;

#ifndef GLYPHS_LITE

- (void)autohintLayers:(NSArray *)Layers;

#endif

- (void)delSelection;

- (void)delSelectionWithModifier:(NSUInteger)ModifierFlag;

- (void)selectionToBackground:(id)sender;

- (IBAction)componentFromSelection:(id)sender;

- (IBAction)swapForegroundWithBackground:(id)sender;

- (GSNode *)connectPathsWithNode:(GSNode *)moveNode andNode:(GSNode *)overNode;

- (GSNode *)nodeAtPoint:(NSPoint)aPoint atLayer:(GSLayer *)Layer excludeNode:(GSNode *)Exclude;

- (GSNode *)nodeAtPoint:(NSPoint)aPoint atLayer:(GSLayer *)Layer excludeNodes:(NSSet *)Excludes traversComponents:(BOOL)traversComponents;

- (void)transformSelection:(NSAffineTransform *)Transform;

- (void)transformSelectionInLayer:(GSLayer *)Layer shadowLayer:(GSLayer *)ShadowLayer transform:(NSAffineTransform *)Transform;

- (void)moveSelectionLayer:(GSLayer *)Layer shadowLayer:(GSLayer *)ShadowLayer withPoint:(NSPoint)aPoint withModifier:(NSUInteger)modifierFlag;

- (void)moveSelectionWithPoint:(NSPoint)Point withModifier:(NSUInteger)modifierFlag;

- (BOOL)setHintDraggingKnob:(GSLayer *)Layer withPoint:(NSPoint)aPoint;

- (void)drawMetricsForLayer:(GSLayer *)Layer atPoint:(NSPoint)Point asActive:(BOOL)Active;

- (void)editAnchorName:(GSAnchor *)Anchor;

- (void)setInterpolate:(GSLayer *)Layer withPoint:(NSPoint)offset;

- (NSString *)selectionEPSDataFromDict:(NSDictionary *)selectedObjects;

- (IBAction)addComponent:(id)sender;

- (IBAction)addAnchor:(id)sender;

- (IBAction)autohint:(id)sender;

- (IBAction)addVHint:(id)sender;

- (IBAction)addHHint:(id)sender;

- (NSArray *)addHintsForNodes:(NSMutableArray *)Nodes toLayer:(GSLayer *)Layer vertical:(BOOL)Vertical type:(GSHintType)Type position:(NSPoint)Position;

- (NSSet *)touchedByHintsIndexes:(GSLayer *)Layer;

- (IBAction)addGuideline:(id)sender;

- (IBAction)reversePaths:(id)sender;

- (IBAction)reverseContour:(id)sender;

- (IBAction)checkConnections:(id)sender;

- (IBAction)addExtrems:(id)sender;

- (IBAction)alignPoints:(id)sender;
#endif

@property (assign) int findSubpathIndex;
@property (assign) int findSubpathCount;
@end
