//
//  LBSVGToBezierPath.h
//  colorplex
//
//  Created by andrei tchijov on 12/9/10.
//  Copyright 2010 Leaping Bytes, LLC. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface LBSVGToBezierPath : NSObject {
  @private
	NSRect viewBox;
	NSPoint lastPoint;
	NSPoint lastOffCurvePoint;
}
@property (nonatomic, assign) NSRect viewBox;
@property (nonatomic, assign) NSPoint lastPoint;

//+ (NSBezierPath*) bezierForSVGPath: (NSString*) svgPath;

+ (void)setBezierViewBox:(NSSize)viewBoxSize;

+ (NSBezierPath *)bezierForSVGPath:(NSString *)svgPath inViewBox:(NSRect)viewBox;

@end
