//
//  GSAlignmentZone.h
//  GlyphsCore
//
//  Created by Georg Seifert on 18.08.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN
@class GSFontMaster;

@interface GSAlignmentZone : NSObject {
	GSFontMaster *__unsafe_unretained _parent;
	NSString *_name;
	NSInteger _position;
	NSInteger _size;
	NSPredicate *_filter;
	NSMutableDictionary *_options;
}
@property (nonatomic, strong, nullable) NSString *name;
@property (nonatomic) NSInteger position;
@property (nonatomic) NSInteger size;
@property (unsafe_unretained, nonatomic, nullable) GSFontMaster *parent;
@property (nonatomic, retain, nullable) NSPredicate *filter;
@property (nonatomic, retain, nullable) NSDictionary *options;
@property (nonatomic, strong, nullable) NSDictionary *delta;

- (instancetype)initWithElementString:(NSString *)String;

- (instancetype)initWithElementDict:(NSDictionary *)Dict;

- (NSString *)elementString;

#ifndef GLYPHS_VIEWER
- (BOOL)saveToFile:(FILE *)File error:(NSError *__autoreleasing *)error;

- (id)propertyListValue;

- (id)objectInSettingsForKey:(NSString *_Nonnull)key;
- (void)setObjectInSettings:(id _Nullable)value forKey:(NSString *_Nonnull)key;

#endif
@end
NS_ASSUME_NONNULL_END
