//
//  GSCFIndexToCFIndexMap.h
//  Glyphs
//
//  Created by Martin Winter on 08.05.17.
//  Copyright © 2017 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void (^GSCFIndexToCFIndexMapEnumeratorBlock)(CFIndex key, CFIndex value);

/**
 Uses a C++ std::map collection internally.
 */
@interface GSCFIndexToCFIndexMap : NSObject <NSCoding>

@property (nonatomic, readonly) NSUInteger count;

- (void)setIndexValue:(CFIndex)indexValue
		  forIndexKey:(CFIndex)indexKey;

- (CFIndex)indexValueForIndexKey:(CFIndex)indexKey;

- (void)removeIndexValueForIndexKey:(CFIndex)indexKey;

/**
 Since std::map always stores keys in sorted order, they will be enumerated in sorted order as well.
 */
- (void)enumerateIndexKeysAndValuesWithBlock:(GSCFIndexToCFIndexMapEnumeratorBlock)block;

@end
