//
//  GSDialogController.h
//  GlyphsCore
//
//  Created by Georg Seifert on 12.09.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSDialogController;

@protocol GSDialogDelegateProtocol <NSObject>
@optional
- (void)confirmDialog:(id)sender;

- (void)cancelDialog:(id)sender;

- (NSString *)okButtonTitleForDialog:(GSDialogController *)Dialog;

- (void)prepareWindow:(NSWindow *)window;
@end

@interface GSDialogController : NSWindowController <NSWindowDelegate>

@property (nonatomic, weak) id<GSDialogDelegateProtocol> delegate;
@property (nonatomic, weak) IBOutlet NSButton *okButton;
@property (nonatomic, weak) IBOutlet NSButton *cancelButton;
@property (nonatomic, weak) IBOutlet NSPopUpButton *helpButton;

- (instancetype)initWithController:(id<GSDialogDelegateProtocol>)Delegate;

- (void)setContentView:(NSView *)ContentView;

- (NSInteger)runDialog:(id)sender;

- (NSInteger)runDialog:(id)sender modalForWindow:(NSWindow *)Window;

- (IBAction)okDialog:(id)sender;

- (IBAction)cancelDialog:(id)sender;

- (void)setTitle:(NSString *)Title;

- (void)setOkStringValue:(NSString *)aString;

//- (IBAction) zoomIn: (id) sender ;
//- (IBAction) zoomOut: (id) sender ;
- (void)setOKSelector:(SEL)aSelector;

- (void)setCancelSelector:(SEL)aSelector;

- (void)addHelpMenuItem:(NSMenuItem *)Item;
@end
