//
//  GSFractionalRange.m
//  GlyphsCore
//
//  Created by Martin Winter on 16.05.17.
//  Copyright © 2017 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 Describes a range with fractional location and length.
 
 This is useful for easily encoding hierarchical locations, e. g. sub-glyohs of characters which are represented by multiple glyphs.
 */
typedef struct _GSFractionalRange {
	CGFloat location;
	CGFloat length;
} GSFractionalRange;

GSFractionalRange GSFractionalRangeMake(CGFloat location, CGFloat length);

/**
 Makes a new range struct from integral (before the decimal point) and fractional (after the decimal point) components.

 @param integralLocation   The integral component of the location.
 @param fractionalLocation The fractional component of the location.
 @param integralLength     The integral component of the length.
 @param fractionalLength   The fractional component of the length.
 @return A new range.
 */
GSFractionalRange GSFractionalRangeMakeFromComponents(NSUInteger integralLocation,
													  NSUInteger fractionalLocation,
													  NSUInteger integralLength,
													  NSUInteger fractionalLength);

/**
 Extracts the integral (before the decimal point) and fractional (after the decimal point) components from a range.
 
 @attention You must ensure that the fractional components of the range are not too long or they may cause an overflow.

 @param range              The range whose components should be extracted.
 @param integralLocation   The integral component of the location.
 @param fractionalLocation The fractional component of the location.
 @param integralLength     The integral component of the length.
 @param fractionalLength   The fractional component of the length.
 */
void GSFractionalRangeGetComponents(GSFractionalRange range,
									NSUInteger *integralLocation,
									NSUInteger *fractionalLocation,
									NSUInteger *integralLength,
									NSUInteger *fractionalLength);
