//
//  GSGlyph+TrueTypeCurves.h
//  GlyphsCore
//
//  Created by Georg Seifert on 11/09/16.
//  Copyright © 2016 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSGlyph.h>

NSPoint offcurvePointForSegment(NSPoint P0, NSPoint P1, NSPoint P2, NSPoint P3);

@class GSPath;

@interface GSGlyph (TrueTypeCurves)
- (NSArray *)decomposeBracketLayersSubstitutions:(NSMutableArray *)substitutions error:(out NSError **)error;
- (BOOL)convertToCompatibleTrueTypeWithError:(CGFloat)curveError error:(out NSError **)error;

+ (BOOL)convertPath:(GSPath *)path toTrueTypeWithError:(CGFloat)curveError error:(out NSError **)error;
@end
