//
//  GSGlyphsFileFormatBase.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.09.19.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSFont;
@class GSProgressWindow;

NS_ASSUME_NONNULL_BEGIN

@protocol GSGlyphsFileFormatDelegate <NSObject>

- (void)finishExport:(id)result;
- (void)cancelExport;

@end

@interface GSGlyphsFileFormatBase : NSViewController {
	GSFont *__weak _font;
	NSOperationQueue *_queue;
	NSMutableString *_result;
	NSDate *_time;
}

/** The GSFont object is assigned the the plugin prior to the export.
 
 This is used to publish the export dialog.
 */

@property (nonatomic, weak) GSFont *font;

@property (readonly) GSProgressWindow *progressWindowController;

@property (nonatomic, unsafe_unretained) id <GSGlyphsFileFormatDelegate> delegate;
@property (nonatomic, strong) NSURL *destinationURL;

@property (readonly, nonatomic) NSView *exportSettingsView;

- (void)showError:(NSError *)error;

- (void)showProgress;
- (void)hideProgress;

- (void)updateProgressWindow:(NSString *)message;
- (void)finishExport;
- (void)cancelExport;
@end

NS_ASSUME_NONNULL_END
