//
//  GSGuideLine.h
//  GlyphsCore
//
//  Created by Georg Seifert on 03.02.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import "GSElement.h"
#import <Cocoa/Cocoa.h>

@class GSHandle;
@class GSLayer;

/*!
 The Guide object
 */
@interface GSGuideLine : GSElement {
	CGFloat _angle;
	NSTextAlignment _alignment;
	GSHandle *_handle;
	BOOL _showMeasurement;
	NSArray *_intersections;
	NSString *_name;
	CGFloat _length;
	CGFloat _grid;
}

/*! the Angle */
@property (nonatomic) CGFloat angle;
/*! Alignment
 NSLeftTextAlignment		= 0,
 NSRightTextAlignment	= 1,
 */
@property (nonatomic) NSTextAlignment alignment;
@property (nonatomic, strong) GSHandle *handle;
@property (nonatomic, assign) BOOL showMeasurement;
@property (nonatomic, strong) NSArray *intersections;
@property (nonatomic, retain) NSString *name;
@property (nonatomic, retain) NSPredicate *filter;
#if DEBUG // GLYPHS 3
@property (nonatomic, assign) CGFloat grid;
@property (nonatomic, assign) CGFloat length;
#endif

- (void)calculateIntersectionsForLayer:(GSLayer *)Layer;

- (BOOL)hitTest:(NSPoint)aPoint inLayer:(GSLayer *)layer tollerance:(CGFloat)tollerance;

- (NSPoint)originPointForLayerWidth:(CGFloat)width;

- (NSPoint)beginPointForLayerWidth:(CGFloat)width;

- (NSPoint)endPointForLayerWidth:(CGFloat)width;
@end
