//
//  GSInspectorViewController.h
//  GlyphsCore
//
//  Created by Georg Seifert on 09.02.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSElement;
@class GSGlyphEditView;
@protocol GSGlyphEditViewControllerProtocol;
@protocol GSGlyphEditViewProtocol;

@interface GSInspectorViewController : NSViewController {
	__unsafe_unretained NSViewController<GSGlyphEditViewControllerProtocol> *_controller;
	__unsafe_unretained id _delegate;
}
@property (unsafe_unretained, nonatomic) id delegate;
@property (unsafe_unretained, nonatomic) NSViewController<GSGlyphEditViewControllerProtocol> *controller;

@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *xField;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *yField;
@property (nonatomic, unsafe_unretained) IBOutlet NSTextField *nameField;
@property (nonatomic, unsafe_unretained) NSView<GSGlyphEditViewProtocol> *glyphEditView;

- (IBAction)setXorigin:(id)sender;
- (IBAction)setYorigin:(id)sender;
- (IBAction)setName:(id)sender;
- (void)update;

- (void)setupUIForObjects:(NSArray *)objects key:(NSString *)key target:(NSTextField *)textField format:(NSString *)format;
- (void)setupUIForObjects:(NSArray *)objects key:(NSString *)key target:(NSTextField *)textField format:(NSString *)format precision:(int)precision;
- (void)setPositionFromObjects:(NSArray *)objects;
- (void)setNameFromObjects:(NSArray *)objects;
- (IBAction)showInUnicodeChecker:(id)sender;
@end
