//
//  GSInterpolationFontProxy.h
//  GlyphsCore
//
//  Created by Georg Seifert on 02.06.15.
//  Copyright (c) 2015 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GSFont;
@class GSGlyph;
@class GSInstance;
@class GSFontMaster;

@interface GSInterpolationFontProxy : NSObject

- (instancetype)initWithFont:(GSFont *)Font instance:(GSInstance *)Instance error:(NSError *__autoreleasing *)error;
- (NSString *)fontMasterID;
- (GSGlyph *)glyphForName:(NSString *)name;
- (GSGlyph *)glyphForCharacter:(UTF32Char)Char;
- (GSGlyph *)glyphForName:(NSString *)Name smartSettings:(NSDictionary *)smartSettings;
- (GSFontMaster *)fontMasterForId:(NSString *)masterID;
- (void)resetCache;

@property (nullable, strong, nonatomic) GSFontMaster *fontMaster;
@end

