//
//  GSPathSegment.h
//  PathOperations
//
//  Created by Georg Seifert on 03.03.14.
//  Copyright (c) 2014 Georg Seifert. All rights reserved.
//

@class GSPointArray;

#import <GlyphsCore/GSNode.h>
#import <GlyphsCore/GSPenProtocol.h>

typedef struct {
	NSPoint elements[4];
	uint8 count;
	GSNodeType type;
	BOOL black; // 0 == white(counter) 1 == black
	CGFloat minX;
	CGFloat maxX;
	CGFloat minY;
	CGFloat maxY;
} GSSegmentStruct;

void _GSSegmentUpdateBounds(GSSegmentStruct *S);

@interface GSPathSegment : NSObject <NSCopying> {

  @public
	NSPoint elements[40];
	GSNodeType type;
	uint8 count;
	BOOL black; // 0 == white(counter) 1 == black
	CGFloat minX;
	CGFloat maxX;
	CGFloat minY;
	CGFloat maxY;
}
@property (nonatomic) GSNodeType type;
@property (nonatomic) uint8 countOfPoints;
@property (strong, nonatomic) NSArray *objects;

- (instancetype)initWithLinePoint1:(NSPoint)P1 point2:(NSPoint)P2 direction:(BOOL)Black;
- (instancetype)initWithCurvePoint1:(NSPoint)P1 point2:(NSPoint)P2 point3:(NSPoint)P3 point4:(NSPoint)P4 direction:(BOOL)Black;
- (instancetype)initWithDescription:(NSString *)string;
- (instancetype)initWithQCurve:(NSArray *)Points;
- (instancetype)initWithQCurve:(NSPoint *)Points count:(int)Count;
- (instancetype)initWithSegmentStruct:(GSSegmentStruct *)S;
- (GSSegmentStruct)segmentStruct;
- (void)updateBounds;
- (void)reverse;
- (NSComparisonResult)compare:(GSPathSegment *)otherObject;
- (BOOL)isEqualToSegment:(GSPathSegment *)otherSegment;
- (NSPoint)middlePoint;
- (NSPoint)middlePointRight;
- (NSPoint)middlePointLeft;
- (void)splitFirstHalf:(GSPathSegment **)left secondHalf:(GSPathSegment **)right;
- (void)splitAtTime:(CGFloat)t firstHalf:(GSPathSegment **)left secondHalf:(GSPathSegment **)right;
- (bool)intersects:(GSPathSegment *)OtherSegment;
- (GSPointArray *)intersectionPoints:(GSPathSegment *)otherSegment;
- (GSPointArray *)intersectionPoints:(GSPathSegment *)otherSegment unlimited:(BOOL)unlimited;
- (NSArray *)inflectionPoints;
- (NSPoint)pointAtIndex:(NSUInteger)idx;
- (void)setPoint:(NSPoint)p atIndex:(NSUInteger)idx;
- (CGFloat)curvatureAtTime:(CGFloat)t;
- (NSPoint)pointAtTime:(CGFloat)t;
- (NSPoint)normalAtTime:(CGFloat)t;
- (CGFloat)length;
- (BOOL)normalizeHandles;
//- (double**) intersections:(GSPathSegment*) OtherSegment NS_RETURNS_INNER_POINTER;
- (void)drawInPen:(NSObject<GSPenProtocol> *)Pen;


/**
 is used in makeCorner and offset paths to connect the segments when there is a gap

 @param otherSegment otherSegment
 @param force if YES, it used a less precice geometry
 @param miterLimit the miter limit
 @return returnes YES if a connection was found
 */
- (BOOL)connectWithSegment:(GSPathSegment *)otherSegment force:(BOOL)force miterLimit:(CGFloat)miterLimit;
@end
