//
//  GSPenProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 16.11.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import "GSNode.h"
#import <Cocoa/Cocoa.h>

@class GSLayer;
@class GSComponent;
@class GSPointArray;

@protocol GSPenProtocol

/** Begin a new sub path, set the current point to 'pt'. You must
end each sub path with a call to pen.closePath() or pen.endPath().
*/
- (void)moveTo:(NSPoint)pt;

/** Draw a straight line from the current point to 'pt'.*/
- (void)lineTo:(NSPoint)pt;

/** Draw a cubic bezier with an arbitrary number of control points.

The last point specified is on-curve, all others are off-curve
(control) points. If the number of control points is > 2, the
segment is split into multiple bezier segments.
*/
- (void)curveTo:(NSPoint)pt off1:(NSPoint)off1 off2:(NSPoint)off2;

/** Draw a whole string of quadratic curve segments.

The last point specified is on-curve, all others are off-curve
points.
*/
- (void)qCurveTo:(GSPointArray *)Points;

- (void)qCurveTo:(GSPointArray *)Points connection:(GSNodeType)connection selected:(BOOL)selected;

/** Close the current sub path. You must call either pen.closePath()
or pen.endPath() after each sub path.
*/
- (void)closePath;

/** End the current sub path, but don't close it. You must call
either pen.closePath() or pen.endPath() after each sub path.
*/
- (void)endPath;

- (void)addComponent:(GSComponent *)component transformation:(NSAffineTransform *)transformation;

@property (readonly, nonatomic) NSPoint lastPoint;

@optional
/**
To initialize stuff
*/
- (void)startGlyph:(GSLayer *)Layer;

- (void)endGlyph:(GSLayer *)Layer;

/// starts an empty new path
- (void)beginPath;

- (void)moveTo:(NSPoint)pt connection:(GSNodeType)connection selected:(BOOL)selected;

- (void)lineTo:(NSPoint)pt connection:(GSNodeType)connection selected:(BOOL)selected;

- (void)curveTo:(NSPoint)pt off1:(NSPoint)off1 off2:(NSPoint)off2 connection:(GSNodeType)connection selected:(BOOL)selected;
- (void)drawInPen:(NSObject<GSPenProtocol> *)pen;

- (void)lineTo:(NSPoint)pt objects:(NSArray *)objects;
- (void)curveTo:(NSPoint)pt off1:(NSPoint)off1 off2:(NSPoint)off2 objects:(NSArray *)objects;

- (void)setHints:(NSArray *)hints;

- (BOOL)ignoreSingleNodes;
- (void)setIgnoreSingleNodes:(BOOL)ignoreSingleNodes;

- (void)qCurveWithPoints:(NSPoint *)points count:(NSUInteger)count;

- (void)setLastPoint:(NSPoint)pt;
@end
