//
//  GSSVGtoPath.h
//  GlyphsCore
//
//  Created by Georg Seifert on 16.11.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSPathPen;
@class GSLayer;

@interface GSSVGtoPath : NSObject {
	NSRect _bounds;
	GSPathPen *_pen;
	NSAffineTransform *_transform;
}

@property NSRect bounds;

- (BOOL)readString:(NSString *)SVGString toLayer:(GSLayer *)Layer error:(NSError *__autoreleasing *)Error;

- (BOOL)readFile:(NSURL *)URL toLayer:(GSLayer *)Layer error:(NSError *__autoreleasing *)Error;

- (void)setUpPen:(GSLayer *)Layer scale:(CGFloat)scale offsetY:(CGFloat)offsetY;

- (BOOL)drawSVGNode:(NSXMLElement *)Node error:(NSError *__autoreleasing *)error;

- (BOOL)drawPathString:(NSString *)pathString error:(NSError *__autoreleasing *)error;
@end
