//
//  NSStringHelpers.h
//  GlyphsCore
//
//  Created by Georg Seifert on 06.08.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#define MAX_UNICODE 0x10FFFF
/// 0xD800
extern NSUInteger const GSNonPrivateUseHighSurrogateFirst;

/// 0xDBFF
extern NSUInteger const GSPrivateUseHighSurrogateLast;

NSString *GSFloatToStringWithPrecision(CGFloat Float, int precision);

void GSFloatToStringWithPrecisionToBuffer(char **buffer, CGFloat Float, int precision);

NSString *GSFloatToStringWithPrecisionMin(CGFloat Float, int precision, int minPrecision);

NSString *GSFloatToStringWithPrecisionLocalized(CGFloat Float, int precision);

NSString *GSFloatToStringLocalized(CGFloat Float);

NSString *GSFloatToString(CGFloat Float);

NSString *GSPointToString(NSPoint P);

void GSIndexPathToBuffer(char **buffer, NSIndexPath *indexPath);

NSString *GSStringFromIndexPath(NSIndexPath *indexPath);

NSIndexPath *GSIndexPathFromString(NSString *string);

@interface NSString (UUID)

#if 0
- (BOOL)containsString:(NSString *)str;
#endif

+ (NSString *)UUID;

+ (NSString *)hexStringFromInt:(NSInteger)Integer;

+ (NSString *)hexStringFromUnsignedInteger:(NSUInteger)Integer;

- (int)hexStringToInt;

+ (NSString *)stringWithChar:(UTF32Char)Char;

- (NSString *)ascciString;

- (NSUInteger)countOfChar:(char)Char;

+ (NSString *)pathForTemporaryFileWithPrefix:(NSString *)prefix;

- (NSString *)absolutePathFromBaseDirPath:(NSString *)baseDirPath;

- (NSString *)relativePathFromBaseDirPath:(NSString *)baseDirPath;

- (NSString *)encodeForPlist;

/**
 @param Index A 16-bit character index, by reference. If the index points to a high surrogate character, it will be incremented on output so that the low surrogate is skipped.
 */
- (UTF32Char)character32AtIndex:(NSUInteger *)Index;

+ (NSString *)encodeForASCII:(NSString *)String;

+ (NSString *)createStringForKey:(CGKeyCode)keyCode;

- (NSString *)stringByDeletingDotSuffix;
- (NSString *)dotSuffix;

- (float)localizedFloatValue;

- (double)localizedDoubleValue;

- (NSString *)stringWithFirstLower;

- (NSString *)stringWithFirstUpper;

- (NSString *)camelCaseToSentenceCase;
@end

unsigned short writeInt(int n, char *restrict s);

void writeKey(FILE *File, NSString *Key);

BOOL writeKeyValueStringEscape(FILE *File, NSString *Key, NSString *Value, BOOL escape);

BOOL writeKeyValueString(FILE *File, NSString *Key, NSString *Value);
BOOL writeKeyValueStringLine(FILE *File, NSString *Key, NSString *Value);
BOOL writeKeyValueStringSimple(FILE *File, NSString *Key, NSString *Value);
BOOL writeKeyValueInt(FILE *File, NSString *Key, int Value);

BOOL writeKeyValueFloat(FILE *File, NSString *Key, CGFloat Value);
BOOL writeKeyValueFloatPrecition(FILE *File, NSString *Key, CGFloat Value, int precition);
BOOL writeTransform(FILE *File, NSAffineTransformStruct ts, BOOL Compact);
char *writeTransformToBuffer(NSAffineTransformStruct ts, char *buffer);
short actualPrecition(CGFloat Float, int precition);
