/*
 *  $Id: SCEventListenerProtocol.h 202 2011-04-22 19:04:02Z stuart $
 *
 *  SCEvents
 *  http://stuconnolly.com/projects/code/
 *
 *  Copyright (c) 2011 Stuart Connolly. All rights reserved.
 *
 *  Permission is hereby granted, free of charge, to any person
 *  obtaining a copy of this software and associated documentation
 *  files (the "Software"), to deal in the Software without
 *  restriction, including without limitation the rights to use,
 *  copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following
 *  conditions:
 *
 *  The above copyright notice and this permission notice shall be
 *  included in all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *  OTHER DEALINGS IN THE SOFTWARE.
 */

@class SCEvents, SCEvent;

/**
* @protocol SCEventListenerProtocol SCEventListenerProtocol.h
*
* @author Stuart Connolly http://stuconnolly.com/
*
* SCEvents' event listenser protocol. Delegates must implement this protocol to be notified of events.
*/
@protocol SCEventListenerProtocol

/**
* Conforming objects' implementation of this method will be called whenever an
* event occurs. The instance of SCEvents which received the event and the event
* itself are passed as parameters.
*
* @param pathWatcher The SCEvents instance that received the event
* @param event	   The actual event that occurred
*/
- (void)pathWatcher:(SCEvents *)pathWatcher eventOccurred:(SCEvent *)event;

@end
