//
//  TTable.h
//  GSFontTools
//
//  Created by Georg Seifert on 24.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class TTFont;
@class GSXMLWriter;

@interface TTable : NSObject {
	NSError* _error;
	NSArray *_glyphOrder;
	NSString * _tableTag;
	NSData * _chachedData; 
	NSUInteger _originalSize;
}
@property (retain, nonatomic) NSError * error;
@property (retain, nonatomic) NSArray * glyphOrder;
@property (retain, nonatomic) NSString * tableTag;
@property (nonatomic, assign) NSUInteger originalSize;

- (id) initWithTag:(NSString*)Tag ;
+ (NSArray*) dependencies;
- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font ;
- (void) fromXML:(NSString*)name attrs:(NSDictionary*) attrs content:(id)content font:(TTFont*)Font ;
- (BOOL) decompile:(NSData*)data font:(TTFont*)Font error:(NSError**)error ;
- (NSData*) compile:(TTFont*)Font error:(NSError**)error ;
//- (NSData*) compileWithFont:(TTFont*)Font ;
@end


@interface DefaultTable : TTable {

}

@end
