//
//  table_S_V_G_.h
//  GSFontTools
//
//  Created by Georg Seifert on 06/09/14.
//
//

#import "TTable.h"

@interface table_S_V_G_ : TTable {
	uint32_t _offsetToSVGDocIndex;
	uint32_t _offsetToColorPalettes;
	uint16_t _numEntries;
	uint16_t _version;
	NSMutableArray *_entries;
	NSMutableArray *_colorPalettes;
}

@property (nonatomic) uint16_t version;
@property (nonatomic, retain) NSMutableArray *entries;
@property (nonatomic, retain) NSMutableArray *colorPalettes;
@end


@interface DocumentIndexEntry : NSObject {
	
@public
	uint16_t _startGlyphID;
	uint16_t _endGlyphID;
	uint32_t _svgDocOffset;
	uint32_t _svgDocLength;
}
@property (strong, nonatomic) NSString * svgDoc;
- (BOOL) decompile:(NSData*)data offset:(NSUInteger*)pos ;
@end


@interface ColorPalettes : NSObject {}
@property (nonatomic, retain) NSMutableArray *colorParamUINameIDs;
@property (nonatomic, retain) NSMutableArray *colorPaletteList;
@end

@interface ColorPalette : NSObject {
	uint8_t _uiNameID;
}
@property (nonatomic, retain) NSMutableArray *paletteColors;
@end

@interface ColorRecord : NSObject {
@public;
	uint8_t  _blue;    //Blue value (B0).
	uint8_t  _green;   //Green value (B1).
	uint8_t  _red;     //Red value (B2).
	uint8_t  _alpha;   //Alpha value (B3).
}
@end