//
//  table__c_m_a_p.h
//  GSFontTools
//
//  Created by Georg Seifert on 24.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TTable.h"

@class TTFont;
//@class MGOrderedDictionary;
@class TTCmapSubtable;

@interface table__c_m_a_p : TTable {
	NSMutableArray * _subTables;
	Fixed _tableVersion;
}
- (TTCmapSubtable*) cmapForPlatformID:(NSUInteger)PlatformID platEncID:(NSUInteger)platEncID ;
- (TTCmapSubtable*) bestCmap;
@end

@interface TTCmapSubtable : NSObject {
	NSUInteger _format;
	NSUInteger _length;
	NSUInteger _platformID;
	NSUInteger _platEncID;
	NSUInteger _languageID;
	NSData * _data;
	TTFont * _font;
	//MGOrderedDictionary * _cmap;
	NSMutableDictionary * _cmap;
}
@property (nonatomic) NSUInteger format;
@property (nonatomic) NSUInteger platformID;
@property (nonatomic) NSUInteger platEncID;
@property (nonatomic) NSUInteger languageID;
//@property (retain, nonatomic) MGOrderedDictionary * cmap;
@property (retain, nonatomic) NSMutableDictionary * cmap;
@property (retain, nonatomic) NSData * data;

- (id) initWithFormat:(NSUInteger) Format;
- (BOOL) decompileHeader:(NSData*) Data font:(TTFont*)Font error:(NSError**) error;
- (BOOL) decompile:(NSData*)Data font:(TTFont*)Font error:(NSError **)error;
- (NSData*) compile:(TTFont*)Font error:(NSError **)error ;

- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font; 
//- (void) _writeCodes:(MGOrderedDictionary*)Codes writer:(GSXMLWriter*) Writer ;
- (void) _writeCodes:(NSMutableDictionary*)Codes writer:(GSXMLWriter*) Writer ;
- (void) fromXML:(NSString*)name attrs:(NSDictionary*) attrs content:(id)content font:(TTFont*)Font ;


@end

@interface cmap_format_0 : TTCmapSubtable {
	
}
@end

@interface cmap_format_2 : TTCmapSubtable {
	
}
@end

@interface cmap_format_4 : TTCmapSubtable {
	
}
@end

@interface cmap_format_6 : TTCmapSubtable {
	
}
@end
@interface cmap_format_12 : TTCmapSubtable {
	NSUInteger _nGroups;
}
@end
@interface cmap_format_14 : TTCmapSubtable {
	NSUInteger _numVarSelectorRecords;
}
@end
@interface cmap_format_unknown : TTCmapSubtable {
	
}
@end