//
//  table__g_l_y_f.h
//  GSFontTools
//
//  Created by Georg Seifert on 01.03.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "TTable.h"

@class OTOrderedDictionary;
@class GSFileData;
@class Glyph_g_l_y_f;
@class TTProgram;

@interface table__g_l_y_f : TTable {
//	NSArray * _glyphOrder;
	OTOrderedDictionary * _glyphs;
}
//@property (nonatomic, retain) NSArray *glyphOrder;
@property (nonatomic, retain) OTOrderedDictionary *glyphs;

- (NSString*) glyphNameAtIndex:(NSUInteger) GlyphID ;
- (NSUInteger) indexOfGlyphName:(NSString*) GlyphName ;
- (Glyph_g_l_y_f*) glyphAtIndex:(NSUInteger) GlyphID ;
- (Glyph_g_l_y_f*) glyphForName:(NSString*) GlyphName ;
- (void) addGlyph:(Glyph_g_l_y_f*) Glyph forKey:(NSString*) GlyphName ;

@end

@interface TTNode : NSObject {
	NSPoint _position;
	u_int8_t _flags;
}
@property (nonatomic, assign) NSPoint position;
@property (nonatomic, assign) u_int8_t flags;
@end

@interface Glyph_g_l_y_f : NSObject {
	NSData * _data;
	short _numberOfContours;
	NSMutableArray * _coordinates;
	NSMutableArray * _components;
	NSMutableArray * _endPtsOfContours;
	NSMutableArray * _flags;
	NSRect _bounds;
	TTProgram * _program;
}
@property (nonatomic, retain) NSData *data;
@property (nonatomic) short numberOfContours;
@property (nonatomic, retain) NSMutableArray *coordinates;
@property (nonatomic, retain) NSMutableArray *components;
@property (nonatomic, retain) TTProgram *program;
@property (nonatomic, retain) NSMutableArray *endPtsOfContours;
@property (nonatomic, retain) NSMutableArray *flags;
@property (nonatomic, assign) NSRect bounds;

- (id) initWithData:(NSData*) Data ;
- (NSData*) compile:(id)glyfTable recalcBBoxes:(BOOL)RecalcBBoxes error:(NSError **)error ;

- (void) expand:(table__g_l_y_f*) glyfTable;
- (void) decompileComponents:(NSData*) Data glyfTable:(table__g_l_y_f*)glyfTable;
- (BOOL) isComposite ;
@end



@interface GlyphComponent_g_l_y_f : NSObject {
	NSAffineTransformStruct _transformStruct;
	NSString * _glyphName;
	BOOL _haveInstructions;
	BOOL _more;
	u_int16_t _flags;
	u_int16_t _glyphID;
	NSUInteger _firstPt;
	NSUInteger _secondPt;
}
@property (nonatomic, retain) NSString *glyphName;
@property (nonatomic, assign) NSAffineTransformStruct transformStruct;
@property (nonatomic, assign) BOOL haveInstructions;
@property (nonatomic, assign) BOOL more;
@property (nonatomic, assign) u_int16_t flags;
@property (nonatomic, assign) NSUInteger firstPt;
@property (nonatomic, assign) NSUInteger secondPt;

- (BOOL) decompile:(GSFileData*) Data glyfTable:(table__g_l_y_f*)glyfTable;
- (NSData*) compileComponents:(table__g_l_y_f*)glyfTable more:(BOOL) More haveInstructions:(BOOL) haveInstructions ;

@end