//
//  GSAnnotation.h
//  GlyphsCore
//
//  Created by Georg Seifert on 28.05.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSElement.h>

@class GSHandle;

typedef enum {
	GSAnnotationTypeSelect = 0,
	GSAnnotationTypeText = 1, 
	GSAnnotationTypeArrow = 2,
	GSAnnotationTypeCircle = 3,
	GSAnnotationTypePlus = 4,
	GSAnnotationTypeMinus = 5
} GSAnnotationType;

@interface GSAnnotation : GSElement {
	NSUInteger _type;
	NSString * _text;
	CGFloat _angle;
	CGFloat _width;
	NSRect _bounds; //onyl cache the drawing bounds;
	GSHandle * _activeHandle;
}
@property (nonatomic, assign) NSUInteger type;
@property (nonatomic, strong) NSString *text;
@property (nonatomic, assign) CGFloat angle;
@property (nonatomic, assign) CGFloat width;
@property (nonatomic, assign) NSRect bounds;
@property (nonatomic, strong) GSHandle *activeHandle;
- (NSRect) handleRectForScale:(CGFloat) Scale;
@end
