//
//  InspectorViewGlyphController.h
//  GlyphsLayerPluginOutline
//
//  Created by Georg Seifert on 08.02.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSInspectorViewController.h"
@class GSLayer;

@interface InspectorViewGlyphController : GSInspectorViewController {
	GSLayer * __unsafe_unretained _previousLayer;
	GSLayer * __unsafe_unretained _nextLayer;
	IBOutlet NSButton *__unsafe_unretained leftExeptionButton;
	IBOutlet NSButton *__unsafe_unretained rightExeptionButton;
	IBOutlet NSTextField *nameField;
	IBOutlet NSTextField *__unsafe_unretained unicodeField;
	IBOutlet NSTextField *__unsafe_unretained leftMetricsField;
	IBOutlet NSTextField *__unsafe_unretained widthField;
	IBOutlet NSTextField *__unsafe_unretained rightMetricsField;
	IBOutlet NSTextField *__unsafe_unretained leftKerningField;
	IBOutlet NSTextField *__unsafe_unretained leftGroupField;
	IBOutlet NSTextField *__unsafe_unretained rightGroupField;
	IBOutlet NSTextField *__unsafe_unretained rightKerningField;
	IBOutlet NSButton *__unsafe_unretained showInUnicodeCheckerButton;
	IBOutlet NSPopUpButton *__unsafe_unretained colorLabelPopup;
	NSImage * exeption;
	NSImage * noExeption;
	NSImage * rightTransferValue;
	NSImage * leftTransferValue;
}

@property(unsafe_unretained, nonatomic) GSLayer * previousLayer;
@property(unsafe_unretained, nonatomic) GSLayer * nextLayer;

- (IBAction) showInUnicodeChecker:(id)sender ;
#ifndef GLYPHS_VIEWER
- (void) setAlternateButtons:(NSNotification*) theNotifivation;

- (IBAction) setName:(id) sender ;
- (IBAction) setLeftMetricsKey:(id) sender ;
- (IBAction) setRightMetricsKey:(id) sender ;
- (IBAction) setWidth:(id) sender ;
- (IBAction) setLeftKerning:(id) sender ;
- (IBAction) setLeftGroup:(id) sender ;
- (IBAction) setLeftExeption:(id) sender ;
- (IBAction) setRightKerning:(id) sender ;
- (IBAction) setRightGroup:(id) sender ;
- (IBAction) setRightExeption:(id) sender ;
#endif
@end
