//
//  GSFeature.h
//  Glyphs
//
//  Created by Georg Seifert on 9.9.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class GSSubstitution;
@class GSFont;
/*! \brief GSFeature: The class defining the feature object
 \ingroup common
 This class defines the feature object.
 */
@interface GSFeature : NSObject <NSCoding, NSCopying> {
	GSFont * __unsafe_unretained _parent;
	NSInteger _index;
	NSString * _name;
	NSString * _code;
	NSMutableArray * _substitutions;
	BOOL _automatic;
	NSString * _notes;
	//NSMutableDictionary * properties;
	NSString * _flag;
}
@property(unsafe_unretained, nonatomic) GSFont * parent;
//@property(retain) NSMutableDictionary * properties;
//! The feature name.
/**
 e.g: "liga", "smcp", ..
 */
@property (copy, nonatomic) NSString *name;
//! The feature representation on FDK syntax.
@property (strong, nonatomic) NSString *code;

//! Returns a dictionary to save in pList.
@property (unsafe_unretained, nonatomic) NSDictionary *featureDict;

//! An array of GSSubstitutions.
@property (strong, nonatomic) NSArray *substitutions;
@property (strong, nonatomic) NSString *flag;
//! Feature will be automaticaly generated.
/**
 Defaults to \a YES, set it to \a NO if you want to edit the feature manually.
 */
@property (nonatomic) BOOL automatic;
//! some notes to add to the feature.
@property (copy, nonatomic) NSString * notes;
#ifndef GLYPHS_VIEWER
- (BOOL) saveToFile:(FILE*) File error:(NSError**) error ;
//! Returns a GSSubstitution object for the source glyph.
- (GSSubstitution *) substitutionForSourceGlyph:(NSString *) Source ;
//! adds the substitution to the font.
- (void) addSubstitution:(GSSubstitution*) subst;
//! Removes the substitution from the font.
- (void) removeSubstitution:(GSSubstitution*) subst;
//! Addes the Array of substitutions to the font.
- (void) addSubstitutions:(NSArray *)substs;
//- (NSString*) saveCodeError:(NSError**) Error;
- (void) update;
#endif
@end
