//
//  GSGlyphViewControllerProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 11.09.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

@class GSLayer;
#import <GlyphsCore/GSGlyphEditViewProtocol.h>

typedef enum {
	GSWritingDirectionNatural     = -1,
	GSWritingDirectionLeftToRight = 0,
	GSWritingDirectionRightToLeft = 1,
	GSWritingDirectionVertialToLeft = 2,
	GSWritingDirectionVertialToRight = 3,
} GSWritingDirection;

@protocol GSGlyphViewControllerProtocol

@property (nonatomic) NSUInteger			masterIndex;
@property (readonly, nonatomic) NSArray		*selectedLayers;
@property (readonly, nonatomic) GSLayer		*activeLayer;
@property (strong, nonatomic) GSLayer		*shadowLayer;
- (id) representedObject;
- (void) setRepresentedObject: (id) RepresentedObject;
@end

@protocol GSGlyphEditViewControllerProtocol <GSGlyphViewControllerProtocol>

@property (readonly, nonatomic) NSView <GSGlyphEditViewProtocol, NSTextInputClient>* graphicView;
@property (nonatomic) GSWritingDirection	writingDirection;
@property (nonatomic, assign) NSInteger		selectedInstance;
@property (readonly, nonatomic) NSArray*	selectedFeatures;

- (void) redraw;
- (void) forceRedraw;
- (void) updateFormatBar;
@end
