//
//  GSGlyphsInfo.h
//  Glyphs
//
//  Created by Georg Seifert on 20.1.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class GSGlyphInfo;
@class GSGlyph;
@class GSFont;
@class GSLayer;
@class MGOrderedDictionary;
/*! \brief GSGlyphsInfos: This is a singlton class to provide glyphinfo services.
 \ingroup common
 This is a singlton class to provide glyphinfo services.
 */
@interface GSGlyphsInfo : NSObject <NSXMLParserDelegate> {
	NSMutableArray*				glyphInfos;
	NSMutableArray*				glyphGroupsTree;
	NSMutableArray*				categories;
	NSDictionary*				_categoryIndexes;
	NSDictionary*				_subcategories;
	NSMutableDictionary*		_name2Group;
	NSMutableDictionary*		_name2Info;
	NSMutableDictionary*		_unicode2Info;
	NSMutableDictionary*		languages;
	NSMutableArray*				scripts;
	NSDictionary*				_scriptIndexes;
	NSDictionary*				anchors; 
	NSDictionary*				_customPropertyTypes;
	NSArray*					_customFontProperties;
	NSArray*					_customMasterProperties;
	NSArray*					_customInstanceProperties;
	NSDictionary*				_basicFontInfoProperties;
	IBOutlet NSArrayController	*glyphGroupsTreeTreeController;
	bool						updating;

	int							defaultFigures;
	NSDictionary				*widthClasses;
	NSDictionary				*weightClasses;
	NSDictionary				*_scriptAbrevations;
	NSDictionary				*_scriptSuffixes;
	NSDictionary				*_languageScripts;
	NSArray						*_unicodeRanges;
	NSMutableDictionary			*_scriptRanges;
@private
	NSMutableDictionary			*subGroupCache;
	NSDateFormatter				*dateFormat;

}
/** An array of glyph groups.

 This is used the build the filter tree in font view mode. 
 */
@property(readonly, nonatomic) NSMutableArray *glyphGroupsTree;
@property(readonly, nonatomic) NSMutableArray *categories;
@property(readonly, nonatomic) NSMutableDictionary *name2Group;
/// The array containing the glyphs info data.
@property(strong, nonatomic) NSMutableArray *glyphInfos;
@property(readonly, nonatomic) NSMutableArray *scripts;
@property(readonly, nonatomic) NSDictionary* customPropertyTypes;
@property(readonly, nonatomic) NSArray* customFontProperties;
@property(readonly, nonatomic) NSArray* customMasterProperties;
@property(readonly, nonatomic) NSArray* customInstanceProperties;

@property(readonly, nonatomic) NSDictionary* basicFontInfoProperties;
@property(readonly, nonatomic) NSMutableDictionary* languages;
/// The widthclasses
@property(readonly, nonatomic) NSDictionary * widthClasses;
/// The weightclasses
@property(readonly, nonatomic) NSDictionary * weightClasses;
@property(readonly, nonatomic) NSDictionary * name2Info;
@property(readonly, nonatomic) NSDictionary *scriptRanges;

/// Returns the shared GlyphsInfos object.
+ (GSGlyphsInfo*) sharedManager;
- (void) loadGlyphInfo ;
+ (NSDateFormatter*) dateFormat;
+ (NSString *) applicationSupportFolder;
- (void) reloadCustomFilterGroup;
- (NSDictionary*) loadCustomFilterGroup;
/** Returns the GSGlyphInfo for the glyph with \a Glyph.
 
 @param Glyph The glyph.
 @return A GSGlyphInfo instance or nil.
 */
+ (GSGlyphInfo*) glyphInfoForGlyph:(GSGlyph*) Glyph ;

/** Returns the GSGlyphInfo for the glyph with \a Name.

 @param Name The glyph name.
 @return A GSGlyphInfo instance or nil.
 */
+ (GSGlyphInfo*) glyphInfoForName:(NSString*) Name ;
/** Returns the GSGlyphInfo for the glyph with \a Unicode.

 @param Unicode A \a unicode as Hex string.
 @return A GSGlyphInfo instance or nil.
 */
+ (GSGlyphInfo*) glyphInfoForUnicode:(NSString*) Unicode ;
/// Returnes the index of the glyph in the database.
- (NSUInteger) glyphIndex:(GSGlyph *) Glyph;
/// Updates the glyph info in the \a Glyph.
+ (void) updateGlyphInfo:(GSGlyph *) Glyph ;
+ (void) updateGlyphInfo:(GSGlyph *) Glyph changeName:(BOOL) ChangeName;
#ifndef GLYPHS_VIEWER
/// Generates missing anchors in the Layer.
+ (BOOL) updateAnchor:(GSLayer*) Layer ;
#endif
/** converts a name to a standardised name
 e.g. converts afii10017 to A-cy
 */
+ (NSString*) niceGlyphNameForName: (NSString*) Name;
+ (NSString*) legacyGlyphNameForName: (NSString*) Name;
+ (NSString*) convertToLegecyNames:(NSString*) OriginalString;
+ (void) fixASCIINames: (GSFont*) Font;
+ (NSString*) decomposeHangul:(unichar) s ;
+ (BOOL) decomposeHangul:(unichar) s leadingConsonant:(unichar*)LeadingConsonant vowel:(unichar*)Vowel trailingConsonant:(unichar*)TrailingConsonant ;
+ (NSArray*) compleationsForName: (NSString*) PartialName forPartialWordRange:(NSRange)charRange ;
+ (NSUInteger) indexOfObjectInScripts:(NSString*) Script;
- (NSUInteger) _indexOfObjectInScripts:(NSString*) Script;
- (NSUInteger) _indexOfObjectInCategories:(NSString*) Category;
- (NSMutableDictionary*) _subcategoriesForCategory:(NSString*) Category;
+ (NSDictionary*) scriptAbrevations;
+ (NSDictionary*) languageScripts;
#ifndef GLYPHS_VIEWER
+ (NSMutableString*) windowsLinkedToStyle:(GSFont*) Font ;
+ (NSMutableString*) macStyle:(GSFont*) Font ;
#endif
- (NSDictionary*) _scriptAbrevations;
- (NSDictionary*) _scriptSuffixes;

+ (NSArray*) unicodeRanges;

+ (NSArray*) _componentsForLigaName:(NSString*) LigaName ;
+ (NSString*) _langTagForName:(NSString*)Name;

+ (NSArray*) blueValues:(NSArray*) AlignmentZones ;
+ (NSArray*) otherBlues:(NSArray*) AlignmentZones ;

@end
