//
//  GSGuideLine.h
//  GlyphsCore
//
//  Created by Georg Seifert on 03.02.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"
@class GSHandle;
@class GSLayer;

@interface GSGuideLine : GSElement {
	CGFloat _angle;
	NSTextAlignment _alignment;
	GSHandle * _handle;
	BOOL _showMeasurement;
	NSArray * _intersections;
}

/** the Angle */
@property (nonatomic) CGFloat angle;
/** Left Aligned */
@property (nonatomic) NSTextAlignment alignment;
@property (nonatomic, strong) GSHandle *handle;
@property (nonatomic, assign) BOOL showMeasurement;
@property (nonatomic, strong) NSArray *intersections;

- (void) calculateIntersectionsForLayer:(GSLayer*) currLayer ;
@end
