/*! \file GSNode.h */
//
//  GSNode.h
//  GlyphsCore
//
//  Created by Georg Seifert on 05.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"
/**
 An enumeration of node and connection types.
 */
typedef enum {
	MOVE = 17,
	LINE = 1, 
	CURVE = 35,
	OFFCURVE = 65,
	SHARP = 0,
	SMOOTH = 4096,
	SPECIAL = 8192
} GSNodeType;

/** \brief GSNode: The class defining the node object
 \ingroup common
 This class defines the node object. It is a subclass of GSElement
 */
@interface GSNode : GSElement <NSCoding, NSCopying> {
@public
	GSNodeType	_type;
	GSNodeType	_connection;
	NSString * _name;
	//CGFloat _time;
	//CGFloat _angle;
	//NSPoint _delta;
}
/// node type
@property(assign, nonatomic) GSNodeType type;
/// connection type
@property(assign, nonatomic) GSNodeType connection;

@property (nonatomic, strong) NSString* name;
#ifdef DEBUG
@property CGFloat time;

@property CGFloat angle;

@property NSPoint delta;
#endif
- (void) setElementString:(NSString*) String;
- (CFStringRef) copyElementString ;
- (id) initWithElementString:(NSString*) ElementString ;
/** toggles the connection type between SHARP and SMOOTH */
- (void) toggleConnection ;
/** Convenient method to make this the first node in the path.*/
- (void)makeNodeFirst;

- (void)setPositionFast:(NSPoint)position;
@end
