//
//  GSWindowControllerProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 26.03.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
@class GSLayer;
@class GSSelectGlyphPanel;
@protocol GlyphsTool;
@protocol GlyphsToolEvent;
@protocol GSGlyphEditViewControllerProtocol;

@protocol GSWindowControllerProtocol

@property (unsafe_unretained, nonatomic) NSResponder<GlyphsTool, GlyphsToolEvent>* toolEventDelegate;
@property (nonatomic) BOOL							ShiftKey, AltKey, CtrlKey, CommandKey, SpaceKey;

- (GSLayer*) activeLayer;
- (GSSelectGlyphPanel*) selectGlyphPanel;
- (NSViewController <GSGlyphEditViewControllerProtocol>*) activeEditViewController;
- (NSUInteger) masterIndex;
- (void) setToolForClass:(Class) aClass;
@end
