//
//  GlyphsToolEventProtocol.h
//  TestToolPlugin
//
//  Created by Georg Seifert on 4.7.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol GSWindowControllerProtocol;
@protocol GSGlyphEditViewControllerProtocol;

@protocol GSGlyphViewControllerProtocol;

/*! \brief GlyphsToolEvent: The protocol defining the tool event plugin protocol
 \ingroup common
 The protocol defining the tool event plugin protocol.
 Every tool needs to conform to this protocol.
 \sa GlyphsToolDraw
 */

#define CLICK_TOLERANCE	4.0

/*! \brief GlyphsToolEvent: Main plugin protocol
 \ingroup common
  All plugins should conform to this protocol. Dditionaly it could conform the draw protocol it it needs to draw. 
 */
typedef enum {
	selectTools = 10,
	editTools  = 20,
	navigationTools = 30
} GSgroupIDs;

@protocol GlyphsTool

//! The main window controller.
@property(unsafe_unretained) NSWindowController<GSWindowControllerProtocol> * windowController;
//! The current editviewcontroller controller.
@property(unsafe_unretained) NSViewController<GSGlyphEditViewControllerProtocol>* editViewController;

- (NSCursor*) standardCursor ;

@end



@protocol GlyphsToolEvent


//! The interface version.
@property (nonatomic, readonly) NSUInteger interfaceVersion;
//! The group ID version.
/**
 selection tools (select, text): 10
 editTools (draw): 20
 navigationTools (hand, zoom): 30
 */
@property (nonatomic, readonly) NSUInteger groupID;
//! The descrition/name of the plugin.
@property (nonatomic, readonly) NSString * title; 
//! The icon displayed in the toolbar.
@property (nonatomic, readonly) NSImage * toolBarIcon;
//! The icon displayed in the toolbar when the button is pressed.
//@property(readonly) NSImage * toolBarIconSelect;

//! The default keyboard shortcut to select the tool.
@property (nonatomic, readonly) NSString * trigger;
//! The trigger (key mask) to select the tool temporarily 
/**
 The select tool is selected with the cmd key. It returns NSCommandKeyMask.
 */
@property(nonatomic, readonly) NSInteger tempTrigger;

//! Set to YES while the mouse is down and dragging.
/**
 The setter should initialise the drag action. (set dragStart)
 */
@property (nonatomic) BOOL dragging;
//! The position where the draggin action had started.
@property (nonatomic) NSPoint draggStart;

//! The keydown handler.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) keyDown:(NSEvent *) theEvent;

//! Informs that the mouse has moved.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) mouseMoved:(NSEvent *) theEvent;

//! Informs that the user has pressed the left mouse button.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) mouseDown:(NSEvent *) theEvent;

//! Informs that the user has moved the mouse with the left button pressed.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) mouseDragged:(NSEvent *) theEvent;

//! Informs the receiver that the user has released the left mouse button.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) mouseUp:(NSEvent *) theEvent;

- (void) modifierChanged:(NSEvent *)anEvent ;
//! Draws some genaeral thing to the backgrund of the edit view.
- (void) willActivate;
- (void) willDeactivate;

- (BOOL) willSelectTempTool:(id) TempTool ;

- (void) drawBackground;
- (void) drawForeground;

//! Copy'n'Past Support
/**
 called from the active tool instance
 **/
//- (void) copy:(id)sender ;
//! Copy'n'Past Support
/**
 called from the active tool instance
 **/
//- (void) paste:(id)sender ;

@optional
- (NSMenu*) toolbarMenu ;
- (void) mouseDoubleDown:(NSEvent *) theEvent;

- (NSMenu*) defaultContextMenu ;
- (void) addMenuItemsForEvent:(NSEvent*) theEvent toMenu:(NSMenu*) theMenu ;
- (void) selectNextSubTool:(id) sender ;
//! returnes the view to place in the inpector
- (id) inspectorViewController;
@end
