//
//  COFont.h
//  GSFontTools
//
//  Created by Georg Seifert on 10.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class TTFont;
//@class MGOrderedDictionary;
@class COInfo;
@class COGSUB;
@class COGPOS;
@class COGDEF;

@class COGlyph;

@interface COFont : NSObject {
	NSString * _path;
	NSString * _fallbackGlyph;
	NSMutableDictionary * _glyphs;
	TTFont * _source;	
	Class _glyphClass;
//	MGOrderedDictionary * _cmap;
//	MGOrderedDictionary * _reversedCmap;
	NSMutableDictionary * _cmap;
	NSMutableDictionary * _reversedCmap;

	id _glyphSet;
	//MGOrderedDictionary * _glyphOrder;
	NSMutableArray * _glyphOrder;
	COInfo * _info;
	COGSUB * _gsub;
	COGPOS * _gpos;
	COGDEF * _gdef;
}
@property (nonatomic, retain) NSMutableDictionary *glyphs;

- (id) initWithPath:(NSString*) Path glyphClass:(Class) GlyphClass ;

- (void) loadCMAP ;
- (void) loadGlyphSet ;
- (void) loadInfo ;
- (void) loadFeatures ;
- (void) resetFeatureStates ;
- (void) setFeatureState:(BOOL) State forTag:(NSString*) FeatureTag ;
- (NSArray*) process:(NSString*) String
			  script:(NSString*) theScriptTag
		  langSysTag:(NSString*) theLangSysTag 
		 rightToLeft:(BOOL) RightToLeft ;
- (NSArray*) processAttributed:(NSAttributedString*) AttributedString
						script:(NSString*) theScriptTag
					langSysTag:(NSString*) theLangSysTag
				   rightToLeft:(BOOL) RightToLeft ;
- (COGlyph*) glyphForName:(NSString*) Name;
@end

@interface COInfo : NSObject {
@public
	NSUInteger unitsPerEm;
	NSUInteger ascender;
	NSInteger descender;
	NSUInteger xHeight;
	NSUInteger capHeight;
	NSArray * names;
}
@end
