//
//  COGlyphRecord.h
//  GSFontTools
//
//  Created by Georg Seifert on 04.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class ValueRecord;

NSMutableArray * glyphNamesToGlyphRecords(NSArray * glyphList) ;
NSMutableArray * glyphRecordsToGlyphNames(NSArray* glyphRecords) ;

@interface COGlyphRecord : NSObject {
	id _glyph;
	NSString * _glyphName;
	NSInteger _xPlacement;
	NSInteger _yPlacement;
	NSInteger _xAdvance;
	NSInteger _yAdvance;
	NSInteger _advanceWidth;
	NSInteger _advanceHeight;
	NSMutableArray * _alternates;
	NSString * _alternatesReference;
	NSArray * _ligatureComponents;
	NSArray * _ligatureComponentsReference;
	NSMutableArray * _substitutionHistory;
	
	NSDictionary * _attributes;
}
@property (retain, nonatomic) NSString * glyphName;
@property (retain, nonatomic) NSArray * ligatureComponents;
@property (retain, nonatomic) NSMutableArray * alternates;
@property (retain, nonatomic) NSString * alternatesReference;
@property (nonatomic, retain) NSDictionary *attributes;
@property (nonatomic, retain) NSMutableArray *substitutionHistory;

- (id) initWithGlyphName:(NSString*) GlyphName ;
- (void) addValues:(ValueRecord*) aValueRecord ;
- (void) saveState:(NSArray*) GlyphNames ;
- (NSString*) side1GlyphNameWithUnicodeValue:(NSDictionary*) reversedCMAP;
- (NSString*) side2GlyphNameWithUnicodeValue:(NSDictionary*) reversedCMAP;
@end
