//
//  SFNTReader.h
//  GSFontTools
//
//  Created by Georg Seifert on 23.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef struct {
	//> # big endian
	char TTCTag[4];							// 4s # "ttcf"
	uint32_t Version;					// L  # 0x00010000 or 0x00020000
	uint32_t numFonts;					// L  # number of fonts
	// unsigned long OffsetTable[numFonts]: // L  # array with offsets from beginning of file
	// unsigned long ulDsigTag:             // L  # version 2.0 only
	// unsigned long ulDsigLength:          // L  # version 2.0 only
	// unsigned long ulDsigOffset:          // L  # version 2.0 only
} ttcHeaderFormat;

//ttcHeaderSize = sstruct.calcsize(ttcHeaderFormat)


//sfntDirectorySize = sstruct.calcsize(sfntDirectoryFormat)

@class TTable;

@interface SFNTReader : NSObject {
	NSString * _path;
	BOOL _checkChecksums;
	NSData * _data;
	NSMutableDictionary * _tables;
	char _sfntVersion[4];
}

@property (nonatomic, readonly) char * sfntVersion;

- (id) initWithPath:(NSString*) Path;
- (BOOL) has_key:(NSString*) Key;
- (NSArray*) allKeys;
- (TTable*) tableForKey:(NSString*) tag;
- (NSData*) tableDataForKey:(NSString*) tag;

- (void) removeTableForKey:(NSString*) tag;
@end
