//
//  TTFont.h
//  GSFontTools
//
//  Created by Georg Seifert on 23.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SFNTReader;
@class TTable;
@class GSXMLWriter;
@class SFNTWriter;

@interface TTFont : NSObject {
	NSString * _path;
	NSMutableDictionary * _tables;
	SFNTReader * _reader;
	NSArray * _glyphOrder;
	BOOL _disassembleInstructions;
	BOOL _verbose;
	BOOL _ignoreDecompileErrors;
	BOOL _recalcBBoxes;
@public	char sfntVersion[4];
}
@property(retain, nonatomic) NSString * path;
@property(retain, nonatomic) NSMutableDictionary * tables;
@property(retain, nonatomic) NSArray * glyphOrder;
@property(nonatomic) BOOL verbose;
@property(nonatomic) BOOL ignoreDecompileErrors;
@property (nonatomic, assign) BOOL recalcBBoxes;

- (id) initWithPath:(NSString*) Path ;
- (BOOL) saveFont:(NSString*) SavePath error:(NSError**)error;
- (void) saveToXML:(NSString*) XMLPath ;
- (void) saveToXML:(NSString *)XMLPath writeTables:(NSArray*)WriteTables skipTables:(NSArray*) SkipTables splitTables:(BOOL) SplitTables disassembleInstructions:(BOOL) DisassembleInstructions;
- (BOOL) isLoaded:(NSString*) Tag ;
- (BOOL) has_key:(NSString*) Tag;
- (NSArray*) allKeys;
//- (NSString*) sfntVersion;
- (NSUInteger) count ;
- (id) tableForKey:(NSString*) Key;
- (void) setTable:(TTable*)Table forKey:(NSString*) Tag ;
- (void) removeTableForKey:(NSString*) tag ;
- (NSArray*) _getGlyphNamesFromCmap ;
- (NSArray*) glyphNames ;
- (NSArray*) glyphNames2 ;
- (NSString*) glyphNameAtIndex:(NSUInteger) GlyphIndex ;
- (NSUInteger) indexOfGlyphForName:(NSString*) GlyphName ;
- (void) _writeTable:(NSString*) Tag writer:(SFNTWriter*) Writer done:(NSMutableArray*)Done ;
- (NSData*) tableDataForKey: (NSString*) Tag ;
- (NSDictionary*) glyphSet ;

@end

Class getTableClass(NSString * tag);
