//
//  TTable.h
//  GSFontTools
//
//  Created by Georg Seifert on 24.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class TTFont;
@class GSXMLWriter;

@interface TTable : NSObject {
	NSError* _error;
	NSMutableArray* _dependencies;
	NSArray *_glyphOrder;
	NSString * _tableTag;
	NSData * _chachedData; 
}
@property (retain, nonatomic) NSError * error;
@property (retain, nonatomic) NSArray * dependencies;
@property (retain, nonatomic) NSArray * glyphOrder;
@property (retain, nonatomic) NSString * tableTag;

- (id) initWithTag:(NSString*)Tag ;

- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*) Font ;
- (void) fromXML:(NSString*)name attrs:(NSDictionary*) attrs content:(id)content font:(TTFont*) Font ;
- (BOOL) decompile:(NSData*)data font:(TTFont*) Font error:(NSError**)error ;
- (NSData*) compile:(TTFont*) Font error:(NSError**)error ;
//- (NSData*) compileWithFont:(TTFont*) Font ;
@end


@interface DefaultTable : TTable {

}

@end
