//
//  table__n_a_m_e.h
//  GSFontTools
//
//  Created by Georg Seifert on 25.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TTable.h"

typedef struct {
// big endian
	uint16_t platformID;
	uint16_t platEncID;
	uint16_t langID;
	uint16_t nameID;
	uint16_t length;
	uint16_t offset;
} nameRecordFormat;

@interface table__n_a_m_e : TTable {
	NSMutableArray * _names;
}
@property (retain, nonatomic) NSMutableArray * names;
@end

@interface TTNameRecord : NSObject {
	NSUInteger _nameID;
	NSUInteger _platformID;
	NSUInteger _platEncID;
	NSUInteger _langID;
	NSString * _string;
}
@property (nonatomic) NSUInteger nameID;
@property (nonatomic) NSUInteger platformID;
@property (nonatomic) NSUInteger platEncID;
@property (nonatomic) NSUInteger langID;
@property (retain, nonatomic) NSString * string;

- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*) Font ;
@end