//
//  GSAnchor.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.8.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"

/// GSAnchorType
enum  {
	BaseAnchor = 0, /**< Anchor in base glyph */
	MarkAnchor = 1 /**< Anchor in mark glyph */
} ;
typedef NSUInteger GSAnchorType;

/// The class defining the anchor object

@interface GSAnchor : GSElement <NSCoding, NSCopying> {
	
	NSString* name; 
	GSAnchorType type;
	BOOL selected;
}
/// Name of the anchor.
@property(copy, nonatomic) NSString* name;
/** Type of the anchor.

 @see GSAnchorType
 */
@property GSAnchorType type;

@end
